/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class MappingResolver {
    private final Set<String> exactMatches;
    private final List<WildcardMatcher> wildcardMatchers;
    private final boolean hasDefault;

    private MappingResolver(Set<String> exactMatches, List<WildcardMatcher> wildcardMatchers, boolean hasDefault) {
        this.exactMatches = exactMatches.isEmpty() ? Collections.emptySet() : exactMatches;
        this.wildcardMatchers = wildcardMatchers.isEmpty() ? Collections.emptyList() : wildcardMatchers;
        this.hasDefault = hasDefault;
    }

    public static MappingResolver build(Collection<String> mappings) {
        ArrayList<WildcardMatcher> wildcardMatchers = new ArrayList<WildcardMatcher>();
        HashSet<String> exactMatches = new HashSet<String>();
        boolean hasDefault = false;
        for (String mapping : mappings) {
            if (mapping.equals("")) {
                exactMatches.add("/");
                continue;
            }
            if (mapping.equals("/") || mapping.equals("/*")) {
                hasDefault = true;
                continue;
            }
            if (mapping.startsWith("*.") && mapping.length() > 2) {
                wildcardMatchers.add(new SuffixMatcher("/" + mapping, mapping.substring(1)));
                continue;
            }
            if (mapping.endsWith("/*")) {
                wildcardMatchers.add(new PrefixMatcher(mapping, mapping.substring(0, mapping.length() - 2)));
                continue;
            }
            exactMatches.add(mapping);
        }
        if (mappings.isEmpty()) {
            hasDefault = true;
        }
        return new MappingResolver(exactMatches, wildcardMatchers, hasDefault);
    }

    @Nullable
    public String resolve(@Nullable String servletPath, @Nullable String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        String path = servletPath;
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        if (path.endsWith("/") && !path.equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (this.exactMatches.contains(path)) {
            return path;
        }
        for (WildcardMatcher matcher : this.wildcardMatchers) {
            if (!matcher.match(path)) continue;
            String mapping = matcher.getMapping();
            if ("/*.jsp".equals(mapping) || "/*.jspx".equals(mapping)) {
                return servletPath;
            }
            return mapping;
        }
        if (this.hasDefault) {
            return path.equals("/") ? "/" : "/*";
        }
        return null;
    }

    public static interface Factory {
        @Nullable
        public MappingResolver get();
    }

    private static class SuffixMatcher
    implements WildcardMatcher {
        private final String mapping;
        private final String suffix;

        private SuffixMatcher(String mapping, String suffix) {
            this.mapping = mapping;
            this.suffix = suffix;
        }

        @Override
        public boolean match(String path) {
            return path.endsWith(this.suffix);
        }

        @Override
        public String getMapping() {
            return this.mapping;
        }
    }

    private static class PrefixMatcher
    implements WildcardMatcher {
        private final String mapping;
        private final String prefix;

        private PrefixMatcher(String mapping, String prefix) {
            this.mapping = mapping;
            this.prefix = prefix;
        }

        @Override
        public boolean match(String path) {
            return path.equals(this.prefix) || path.startsWith(this.prefix + "/");
        }

        @Override
        public String getMapping() {
            return this.mapping;
        }
    }

    private static interface WildcardMatcher {
        public boolean match(String var1);

        public String getMapping();
    }
}

