/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.PropagatedContext;
import io.opentelemetry.javaagent.instrumentation.api.internal.InstrumentedTaskClasses;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ExecutorAdviceHelper {
    public static boolean shouldPropagateContext(Context context, @Nullable Object task) {
        if (task == null) {
            return false;
        }
        if (context == Context.root()) {
            return false;
        }
        return InstrumentedTaskClasses.canInstrumentTaskClass(task.getClass());
    }

    public static <T> PropagatedContext attachContextToTask(Context context, ContextStore<T, PropagatedContext> contextStore, T task) {
        PropagatedContext propagatedContext = contextStore.putIfAbsent(task, PropagatedContext.FACTORY);
        if (ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            context = ContextPropagationDebug.appendLocations(context, new Exception().getStackTrace(), task);
        }
        propagatedContext.setContext(context);
        return propagatedContext;
    }

    public static void cleanUpAfterSubmit(@Nullable PropagatedContext propagatedContext, @Nullable Throwable throwable) {
        if (propagatedContext != null && throwable != null) {
            propagatedContext.clear();
        }
    }

    private ExecutorAdviceHelper() {
    }
}

