/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.CompositeSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.NoopSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.StoreOnlyStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SuppressIfSameSpanKeyStrategy;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.Set;

abstract class SpanSuppressionStrategy {
    private static final SpanSuppressionStrategy SERVER_STRATEGY = new SuppressIfSameSpanKeyStrategy(Collections.singleton(SpanKey.SERVER));
    private static final SpanSuppressionStrategy CONSUMER_STRATEGY = new StoreOnlyStrategy(Collections.singleton(SpanKey.CONSUMER));
    private static final SpanSuppressionStrategy ALL_CLIENTS_STRATEGY = new SuppressIfSameSpanKeyStrategy(Collections.singleton(SpanKey.ALL_CLIENTS));
    private static final SpanSuppressionStrategy ALL_PRODUCERS_STRATEGY = new SuppressIfSameSpanKeyStrategy(Collections.singleton(SpanKey.ALL_PRODUCERS));
    public static final SpanSuppressionStrategy SUPPRESS_ALL_NESTED_OUTGOING_STRATEGY = new CompositeSuppressionStrategy(ALL_CLIENTS_STRATEGY, ALL_PRODUCERS_STRATEGY, SERVER_STRATEGY, CONSUMER_STRATEGY);
    private static final SpanSuppressionStrategy NO_CLIENT_SUPPRESSION_STRATEGY = new CompositeSuppressionStrategy(NoopSuppressionStrategy.INSTANCE, NoopSuppressionStrategy.INSTANCE, SERVER_STRATEGY, CONSUMER_STRATEGY);

    SpanSuppressionStrategy() {
    }

    static SpanSuppressionStrategy from(Set<SpanKey> clientSpanKeys) {
        if (clientSpanKeys.isEmpty()) {
            return NO_CLIENT_SUPPRESSION_STRATEGY;
        }
        SuppressIfSameSpanKeyStrategy clientOrProducerStrategy = new SuppressIfSameSpanKeyStrategy(clientSpanKeys);
        return new CompositeSuppressionStrategy(clientOrProducerStrategy, clientOrProducerStrategy, SERVER_STRATEGY, CONSUMER_STRATEGY);
    }

    abstract Context storeInContext(Context var1, SpanKind var2, Span var3);

    abstract boolean shouldSuppress(Context var1, SpanKind var2);
}

