/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.Callable;

public final class CallableWrapper<T>
implements Callable<T> {
    private static final Logger logger = LoggerFactory.getLogger(CallableWrapper.class);
    private final Callable<T> callable;

    public static Callable<?> wrapIfNeeded(Callable<?> task) {
        if (task.getClass().getName().contains("/") && !(task instanceof CallableWrapper)) {
            logger.debug("Wrapping callable task {}", (Object)task);
            return new CallableWrapper(task);
        }
        return task;
    }

    private CallableWrapper(Callable<T> callable) {
        this.callable = callable;
    }

    @Override
    public T call() throws Exception {
        return this.callable.call();
    }
}

