/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.javaagent.bootstrap.internal.DeprecatedConfigPropertyWarning;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.Collections;
import java.util.List;

public final class ExperimentalConfig {
    private static final ExperimentalConfig instance = new ExperimentalConfig(InstrumentationConfig.get());
    private final InstrumentationConfig config;
    private final List<String> messagingHeaders;

    public static ExperimentalConfig get() {
        return instance;
    }

    public ExperimentalConfig(InstrumentationConfig config) {
        this.config = config;
        this.messagingHeaders = config.getList("otel.instrumentation.messaging.experimental.capture-headers", Collections.emptyList());
    }

    public boolean controllerTelemetryEnabled() {
        DeprecatedConfigPropertyWarning.warnIfUsed(this.config, "otel.instrumentation.common.experimental.suppress-controller-spans", "otel.instrumentation.common.experimental.controller-telemetry.enabled");
        boolean suppressControllerSpans = this.config.getBoolean("otel.instrumentation.common.experimental.suppress-controller-spans", false);
        return this.config.getBoolean("otel.instrumentation.common.experimental.controller-telemetry.enabled", !suppressControllerSpans);
    }

    public boolean viewTelemetryEnabled() {
        DeprecatedConfigPropertyWarning.warnIfUsed(this.config, "otel.instrumentation.common.experimental.suppress-view-spans", "otel.instrumentation.common.experimental.view-telemetry.enabled");
        boolean suppressViewSpans = this.config.getBoolean("otel.instrumentation.common.experimental.suppress-view-spans", false);
        return this.config.getBoolean("otel.instrumentation.common.experimental.view-telemetry.enabled", !suppressViewSpans);
    }

    public boolean messagingReceiveInstrumentationEnabled() {
        DeprecatedConfigPropertyWarning.warnIfUsed(this.config, "otel.instrumentation.common.experimental.suppress-messaging-receive-spans", "otel.instrumentation.messaging.experimental.receive-telemetry.enabled");
        boolean receiveSpansSuppressed = this.config.getBoolean("otel.instrumentation.common.experimental.suppress-messaging-receive-spans", true);
        return this.config.getBoolean("otel.instrumentation.messaging.experimental.receive-telemetry.enabled", !receiveSpansSuppressed);
    }

    public List<String> getMessagingHeaders() {
        return this.messagingHeaders;
    }
}

