/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.AutoValue_RpcServerMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.MetricsView;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

@UnstableApi
public final class RpcServerMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_SERVER_REQUEST_METRICS_STATE = ContextKey.named("rpc-server-request-metrics-state");
    private static final Logger logger = LoggerFactory.getLogger(RpcServerMetrics.class);
    private final DoubleHistogram serverDurationHistogram;

    private RpcServerMetrics(Meter meter) {
        this.serverDurationHistogram = meter.histogramBuilder("rpc.server.duration").setDescription("The duration of an inbound RPC invocation").setUnit("ms").build();
    }

    @UnstableApi
    public static RequestMetrics get() {
        return RpcServerMetrics::new;
    }

    @Override
    public Context start(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_SERVER_REQUEST_METRICS_STATE, new AutoValue_RpcServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void end(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(RPC_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.debug("No state present when ending context {}. Cannot record RPC request metrics.", (Object)context);
            return;
        }
        this.serverDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, MetricsView.applyServerView(state.startAttributes(), endAttributes), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

