/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

public interface WeakMap<K, V> {
    public int size();

    public boolean containsKey(K var1);

    public V get(K var1);

    public void put(K var1, V var2);

    public void putIfAbsent(K var1, V var2);

    public V computeIfAbsent(K var1, ValueSupplier<? super K, ? extends V> var2);

    public V remove(K var1);

    public static class MapAdapter<K, V>
    implements WeakMap<K, V> {
        private final Map<K, V> map;

        public MapAdapter(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean containsKey(K key) {
            return this.map.containsKey(key);
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        @Override
        public void put(K key, V value) {
            this.map.put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putIfAbsent(K key, V value) {
            if (!this.map.containsKey(key)) {
                MapAdapter mapAdapter = this;
                synchronized (mapAdapter) {
                    if (!this.map.containsKey(key)) {
                        this.map.put(key, value);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(K key, ValueSupplier<? super K, ? extends V> supplier) {
            if (this.map.containsKey(key)) {
                return this.map.get(key);
            }
            MapAdapter mapAdapter = this;
            synchronized (mapAdapter) {
                if (this.map.containsKey(key)) {
                    return this.map.get(key);
                }
                V value = supplier.get(key);
                this.map.put(key, value);
                return value;
            }
        }

        @Override
        public V remove(K key) {
            return this.map.remove(key);
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static interface ValueSupplier<K, V> {
        public V get(K var1);
    }

    public static interface Implementation {
        public static final Implementation DEFAULT = new Default();

        public <K, V> WeakMap<K, V> get();

        public static class Default
        implements Implementation {
            private static final Logger log = LoggerFactory.getLogger(Default.class);

            @Override
            public <K, V> WeakMap<K, V> get() {
                log.debug("WeakMap.Supplier not registered. Returning a synchronized WeakHashMap.");
                return new MapAdapter(Collections.synchronizedMap(new WeakHashMap()));
            }
        }
    }

    public static class Provider {
        private static final Logger log = LoggerFactory.getLogger(Provider.class);
        private static final AtomicReference<Implementation> provider = new AtomicReference<Implementation>(Implementation.DEFAULT);

        public static void registerIfAbsent(Implementation provider) {
            if (provider != null && provider != Implementation.DEFAULT && Provider.provider.compareAndSet(Implementation.DEFAULT, provider)) {
                log.debug("Weak map provider set to {}", (Object)provider);
            }
        }

        public static boolean isProviderRegistered() {
            return provider.get() != Implementation.DEFAULT;
        }

        public static <K, V> WeakMap<K, V> newWeakMap() {
            return provider.get().get();
        }
    }
}

