/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.context.internal.shaded;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractWeakConcurrentMap<K, V, L>
extends ReferenceQueue<K>
implements Runnable,
Iterable<Map.Entry<K, V>> {
    final ConcurrentMap<WeakKey<K>, V> target;

    protected AbstractWeakConcurrentMap() {
        this(new ConcurrentHashMap());
    }

    protected AbstractWeakConcurrentMap(ConcurrentMap<WeakKey<K>, V> target) {
        this.target = target;
    }

    protected abstract L getLookupKey(K var1);

    protected abstract void resetLookupKey(L var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V previousValue;
        Object value;
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            value = this.target.get(lookupKey);
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
        if (value == null && (value = this.defaultValue(key)) != null && (previousValue = this.target.putIfAbsent(new WeakKey<K>(key, this), value)) != null) {
            value = previousValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfPresent(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            Object v = this.target.get(lookupKey);
            return v;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            boolean bl = this.target.containsKey(lookupKey);
            return bl;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.target.put(new WeakKey<K>(key, this), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        Object previous;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            previous = this.target.get(lookupKey);
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
        return previous == null ? this.target.putIfAbsent(new WeakKey<K>(key, this), value) : previous;
    }

    public V putIfProbablyAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.target.putIfAbsent(new WeakKey<K>(key, this), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            Object v = this.target.remove(lookupKey);
            return v;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    public void clear() {
        this.target.clear();
    }

    protected V defaultValue(K key) {
        return null;
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.target.remove(reference);
        }
    }

    public int approximateSize() {
        return this.target.size();
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.target.remove(this.remove());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator(this.target.entrySet().iterator());
    }

    public String toString() {
        return this.target.toString();
    }

    private class SimpleEntry
    implements Map.Entry<K, V> {
        private final K key;
        final Map.Entry<WeakKey<K>, V> entry;

        private SimpleEntry(K key, Map.Entry<WeakKey<K>, V> entry) {
            this.key = key;
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return this.entry.setValue(value);
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<WeakKey<K>, V>> iterator;
        private Map.Entry<WeakKey<K>, V> nextEntry;
        private K nextKey;

        private EntryIterator(Iterator<Map.Entry<WeakKey<K>, V>> iterator) {
            this.iterator = iterator;
            this.findNext();
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.nextEntry = this.iterator.next();
                this.nextKey = this.nextEntry.getKey().get();
                if (this.nextKey == null) continue;
                return;
            }
            this.nextEntry = null;
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            try {
                SimpleEntry simpleEntry = new SimpleEntry(this.nextKey, this.nextEntry);
                return simpleEntry;
            }
            finally {
                this.findNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;

        WeakKey(K key, ReferenceQueue<? super K> queue) {
            super(key, queue);
            this.hashCode = System.identityHashCode(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other instanceof WeakKey) {
                return ((WeakKey)other).get() == this.get();
            }
            return other.equals(this);
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }
}

