/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Utils {
    private Utils() {
    }

    public static void checkArgument(boolean isValid, String errorMessage) {
        if (!isValid) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Utils.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean isValid, String errorMessage) {
        if (!isValid) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        if (args.length == 0) {
            return template;
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static void validateLabelPairs(String[] keyValuePairs) {
        Utils.checkArgument(keyValuePairs.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String key = keyValuePairs[i];
            Objects.requireNonNull(key, "You cannot provide null keys for label creation.");
        }
    }
}

