/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.bootstrap.IndyBootstrapDispatcher;
import io.opentelemetry.javaagent.bootstrap.advice.AdviceForwardLookupSupplier;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ForwardIndyAdviceTransformer
implements AgentBuilder.Transformer {
    private static final AtomicInteger counter = new AtomicInteger();
    private static final String bootForwardClassPackage = AdviceForwardLookupSupplier.class.getPackage().getName();
    private final HelperInjector helperInjector;

    public ForwardIndyAdviceTransformer(HelperInjector helperInjector) {
        this.helperInjector = helperInjector;
    }

    private static boolean isAtLeastJava7(TypeDescription typeDescription) {
        ClassFileVersion classFileVersion = typeDescription.getClassFileVersion();
        return classFileVersion != null && classFileVersion.getJavaVersion() >= 7;
    }

    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, final ClassLoader classLoader, JavaModule javaModule, ProtectionDomain protectionDomain) {
        if (ForwardIndyAdviceTransformer.isAtLeastJava7(typeDescription)) {
            return builder;
        }
        return builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.AbstractBase(){

            public ClassVisitor wrap(TypeDescription typeDescription, ClassVisitor classVisitor, Implementation.Context context, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fieldList, MethodList<?> methodList, int writerFlags, int readerFlags) {
                return new ClassVisitor(589824, classVisitor){
                    final Map<String, Supplier<byte[]>> injectedClasses;
                    {
                        this.injectedClasses = new HashMap<String, Supplier<byte[]>>();
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        if (!this.injectedClasses.isEmpty()) {
                            ForwardIndyAdviceTransformer.this.helperInjector.injectHelperClasses(classLoader, this.injectedClasses);
                        }
                    }

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                        return new MethodVisitor(this.api, mv){

                            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                                if (Type.getInternalName(IndyBootstrapDispatcher.class).equals(bootstrapMethodHandle.getOwner())) {
                                    String adviceClassName = (String)bootstrapMethodArguments[3];
                                    String forwardClassDotName = classLoader == null ? bootForwardClassPackage + ".Forward$$" + counter.incrementAndGet() : adviceClassName + "$$Forward$$" + counter.incrementAndGet();
                                    String forwardClassSlasName = forwardClassDotName.replace('.', '/');
                                    Supplier forwardClassBytes = ForwardIndyAdviceTransformer.generateForwardClass(forwardClassSlasName, name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                                    injectedClasses.put(forwardClassDotName, forwardClassBytes);
                                    super.visitMethodInsn(184, forwardClassSlasName, name, descriptor, false);
                                    return;
                                }
                                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                            }
                        };
                    }
                };
            }
        });
    }

    private static Supplier<byte[]> generateForwardClass(String forwardClassSlasName, String methodName, String methodDescriptor, Handle bootstrapMethodHandle, Object[] bootstrapMethodArguments) {
        return () -> {
            ClassWriter cw = new ClassWriter(1);
            cw.visit(52, 1, forwardClassSlasName, null, Type.getInternalName(Object.class), null);
            MethodVisitor mv = cw.visitMethod(9, methodName, methodDescriptor, null, null);
            GeneratorAdapter ga = new GeneratorAdapter(mv, 9, methodName, methodDescriptor);
            ga.loadArgs();
            mv.visitInvokeDynamicInsn(methodName, methodDescriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            ga.returnValue();
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            return cw.toByteArray();
        };
    }
}

