/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.javaagent.bootstrap.field.VirtualFieldAccessorMarker;

final class GeneratedVirtualFieldNames {
    static final String DYNAMIC_CLASSES_PACKAGE = VirtualFieldAccessorMarker.class.getPackage().getName() + ".";

    private GeneratedVirtualFieldNames() {
    }

    public static boolean isVirtualFieldInterfaceName(String className) {
        return className.startsWith(DYNAMIC_CLASSES_PACKAGE + "VirtualFieldAccessor$");
    }

    static String getVirtualFieldImplementationClassName(String typeName, String fieldTypeName) {
        return DYNAMIC_CLASSES_PACKAGE + "VirtualFieldImpl$" + GeneratedVirtualFieldNames.sanitizeClassName(typeName) + "$" + GeneratedVirtualFieldNames.sanitizeClassName(fieldTypeName);
    }

    static String getFieldAccessorInterfaceName(String typeName, String fieldTypeName) {
        return DYNAMIC_CLASSES_PACKAGE + "VirtualFieldAccessor$" + GeneratedVirtualFieldNames.sanitizeClassName(typeName) + "$" + GeneratedVirtualFieldNames.sanitizeClassName(fieldTypeName);
    }

    static String getRealFieldName(String typeName, String fieldTypeName) {
        return "__opentelemetryVirtualField$" + GeneratedVirtualFieldNames.sanitizeClassName(typeName) + "$" + GeneratedVirtualFieldNames.sanitizeClassName(fieldTypeName);
    }

    static String getRealGetterName(String typeName, String fieldTypeName) {
        return "__get" + GeneratedVirtualFieldNames.getRealFieldName(typeName, fieldTypeName);
    }

    static String getRealSetterName(String typeName, String fieldTypeName) {
        return "__set" + GeneratedVirtualFieldNames.getRealFieldName(typeName, fieldTypeName);
    }

    private static String sanitizeClassName(String className) {
        if ((className = className.replace('.', '$')).endsWith("[]")) {
            className = className.replace('[', '_').replace(']', '_');
        }
        return className;
    }
}

