/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.commons.Remapper;

public class ShadingRemapper
extends Remapper {
    private final TreeMap<String, String> map = new TreeMap();

    public static Rule rule(String from, String to) {
        return new Rule(from, to);
    }

    public ShadingRemapper(Rule ... rules) {
        for (Rule rule : rules) {
            this.map.put(rule.from, rule.to);
        }
    }

    public String map(String internalName) {
        Map.Entry<String, String> e = this.map.floorEntry(internalName);
        if (e != null && internalName.startsWith(e.getKey())) {
            return e.getValue() + internalName.substring(e.getKey().length());
        }
        return super.map(internalName);
    }

    public static class Rule {
        private final String from;
        private final String to;

        public Rule(String from, String to) {
            if (from.startsWith("#")) {
                from = from.substring(1);
            }
            if (to.startsWith("#")) {
                to = to.substring(1);
            }
            this.from = from.replace('.', '/');
            this.to = to.replace('.', '/');
        }
    }
}

