/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.instrumentation.api.internal.RuntimeVirtualFieldSupplier;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.tooling.field.GeneratedVirtualFieldNames;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;

final class RuntimeFieldBasedImplementationSupplier
implements RuntimeVirtualFieldSupplier.VirtualFieldSupplier {
    RuntimeFieldBasedImplementationSupplier() {
    }

    public <U extends T, V extends F, T, F> VirtualField<U, V> find(Class<T> type, Class<F> fieldType) {
        if (System.getSecurityManager() == null) {
            return RuntimeFieldBasedImplementationSupplier.findInternal(type, fieldType);
        }
        return AccessController.doPrivileged(() -> RuntimeFieldBasedImplementationSupplier.findInternal(type, fieldType));
    }

    private static <U extends T, V extends F, T, F> VirtualField<U, V> findInternal(Class<T> type, Class<F> fieldType) {
        try {
            String virtualFieldImplClassName = GeneratedVirtualFieldNames.getVirtualFieldImplementationClassName(type.getTypeName(), fieldType.getTypeName());
            Class<?> contextStoreClass = Class.forName(virtualFieldImplClassName, false, null);
            Method method = contextStoreClass.getMethod("getVirtualField", Class.class, Class.class);
            VirtualField field = (VirtualField)method.invoke(null, type, fieldType);
            return field;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("VirtualField not found", exception);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException("Failed to get VirtualField", exception);
        }
    }
}

