/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.extension.noopapi.NoopOpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.javaagent.instrumentation.api.OpenTelemetrySdkAccess;
import io.opentelemetry.javaagent.tooling.config.ConfigPropertiesAdapter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={AgentListener.class})
public class OpenTelemetryInstaller
implements AgentListener {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetryInstaller.class);
    static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    static final String JAVAAGENT_NOOP_CONFIG = "otel.javaagent.experimental.use-noop-api";

    public void beforeAgent(Config config) {
        OpenTelemetryInstaller.installAgentTracer(config);
    }

    public static synchronized void installAgentTracer(Config config) {
        if (config.getBoolean(JAVAAGENT_ENABLED_CONFIG, true)) {
            if (config.getBoolean(JAVAAGENT_NOOP_CONFIG, false)) {
                GlobalOpenTelemetry.set((OpenTelemetry)NoopOpenTelemetry.getInstance());
            } else {
                System.setProperty("io.opentelemetry.context.contextStorageProvider", "default");
                OpenTelemetrySdk sdk = OpenTelemetrySdkAutoConfiguration.initialize((boolean)true, (ConfigProperties)new ConfigPropertiesAdapter(config));
                OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> {
                    CompletableResultCode traceResult = sdk.getSdkTracerProvider().forceFlush();
                    MeterProvider meterProvider = GlobalMeterProvider.get();
                    CompletableResultCode metricsResult = meterProvider instanceof SdkMeterProvider ? ((SdkMeterProvider)meterProvider).forceFlush() : CompletableResultCode.ofSuccess();
                    CompletableResultCode.ofAll(Arrays.asList(traceResult, metricsResult)).join((long)timeout, unit);
                });
            }
        } else {
            logger.info("Tracing is disabled.");
        }
    }
}

