/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.ignore;

import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.instrumentation.api.util.Trie;
import io.opentelemetry.javaagent.tooling.ignore.IgnoreAllow;

public class IgnoredTypesBuilderImpl
implements IgnoredTypesBuilder {
    private final Trie.Builder<IgnoreAllow> ignoredTypesTrie = Trie.newBuilder();
    private final Trie.Builder<IgnoreAllow> ignoredClassLoadersTrie = Trie.newBuilder();
    private final Trie.Builder<Boolean> ignoredTasksTrie = Trie.newBuilder();

    public IgnoredTypesBuilder ignoreClass(String classNameOrPrefix) {
        this.ignoredTypesTrie.put((CharSequence)classNameOrPrefix, (Object)IgnoreAllow.IGNORE);
        return this;
    }

    public IgnoredTypesBuilder allowClass(String classNameOrPrefix) {
        this.ignoredTypesTrie.put((CharSequence)classNameOrPrefix, (Object)IgnoreAllow.ALLOW);
        return this;
    }

    public IgnoredTypesBuilder ignoreClassLoader(String classNameOrPrefix) {
        this.ignoredClassLoadersTrie.put((CharSequence)classNameOrPrefix, (Object)IgnoreAllow.IGNORE);
        return this;
    }

    public IgnoredTypesBuilder allowClassLoader(String classNameOrPrefix) {
        this.ignoredClassLoadersTrie.put((CharSequence)classNameOrPrefix, (Object)IgnoreAllow.ALLOW);
        return this;
    }

    public IgnoredTypesBuilder ignoreTaskClass(String classNameOrPrefix) {
        this.ignoredTasksTrie.put((CharSequence)classNameOrPrefix, (Object)true);
        return this;
    }

    public Trie<IgnoreAllow> buildIgnoredTypesTrie() {
        return this.ignoredTypesTrie.build();
    }

    public Trie<IgnoreAllow> buildIgnoredClassLoadersTrie() {
        return this.ignoredClassLoadersTrie.build();
    }

    public Trie<Boolean> buildIgnoredTasksTrie() {
        return this.ignoredTasksTrie.build();
    }
}

