/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import java.util.function.Predicate;

public final class InstrumentationClassPredicate {
    private static final String JAVAAGENT_INSTRUMENTATION_PACKAGE = "io.opentelemetry.javaagent.instrumentation.";
    private static final String JAVAAGENT_API_PACKAGE = "io.opentelemetry.javaagent.instrumentation.api.";
    private static final String LIBRARY_INSTRUMENTATION_PACKAGE = "io.opentelemetry.instrumentation.";
    private static final String INSTRUMENTATION_API_PACKAGE = "io.opentelemetry.instrumentation.api.";
    private final Predicate<String> additionalLibraryInstrumentationPredicate;

    public InstrumentationClassPredicate(Predicate<String> additionalLibraryInstrumentationPredicate) {
        this.additionalLibraryInstrumentationPredicate = additionalLibraryInstrumentationPredicate;
    }

    public boolean isInstrumentationClass(String className) {
        return InstrumentationClassPredicate.isJavaagentInstrumentationClass(className) || InstrumentationClassPredicate.isLibraryInstrumentationClass(className) || this.additionalLibraryInstrumentationPredicate.test(className);
    }

    public boolean isProvidedByLibrary(String className) {
        return !this.isInstrumentationClass(className) && !InstrumentationClassPredicate.isProvidedByJavaagent(className);
    }

    private static boolean isProvidedByJavaagent(String className) {
        return className.startsWith(JAVAAGENT_API_PACKAGE) || className.startsWith(INSTRUMENTATION_API_PACKAGE) || className.startsWith("io.opentelemetry.javaagent.bootstrap.") || className.startsWith("io.opentelemetry.api.") || className.startsWith("io.opentelemetry.context.") || className.startsWith("io.opentelemetry.semconv.") || className.startsWith("org.slf4j.");
    }

    private static boolean isJavaagentInstrumentationClass(String className) {
        return className.startsWith(JAVAAGENT_INSTRUMENTATION_PACKAGE) && !className.startsWith(JAVAAGENT_API_PACKAGE);
    }

    private static boolean isLibraryInstrumentationClass(String className) {
        return className.startsWith(LIBRARY_INSTRUMENTATION_PACKAGE) && !className.startsWith(INSTRUMENTATION_API_PACKAGE);
    }
}

