/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.context;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.bootstrap.FieldBackedContextStoreAppliedMarker;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.extension.matcher.ClassLoaderMatcher;
import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.api.InstrumentationContext;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.context.InstrumentationContextProvider;
import io.opentelemetry.javaagent.tooling.instrumentation.InstrumentationModuleInstaller;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;

public class FieldBackedProvider
implements InstrumentationContextProvider {
    private static final TransformSafeLogger log = TransformSafeLogger.getLogger(FieldBackedProvider.class);
    private static final String DYNAMIC_CLASSES_PACKAGE = "io.opentelemetry.javaagent.bootstrap.instrumentation.context.";
    private static final String INJECTED_FIELDS_MARKER_CLASS_NAME = Utils.getInternalName(FieldBackedContextStoreAppliedMarker.class);
    private static final Method CONTEXT_GET_METHOD;
    private static final Method GET_CONTEXT_STORE_METHOD;
    private static final boolean FIELD_INJECTION_ENABLED;
    private final Class<?> instrumenterClass;
    private final ByteBuddy byteBuddy;
    private final Map<String, String> contextStore;
    private final Map<String, DynamicType.Unloaded<?>> fieldAccessorInterfaces;
    private final AgentBuilder.Transformer fieldAccessorInterfacesInjector;
    private final Map<String, DynamicType.Unloaded<?>> contextStoreImplementations;
    private final AgentBuilder.Transformer contextStoreImplementationsInjector;
    private static final Set<Map.Entry<String, String>> INSTALLED_CONTEXT_MATCHERS;

    public FieldBackedProvider(Class<?> instrumenterClass, Map<String, String> contextStore) {
        this.instrumenterClass = instrumenterClass;
        this.contextStore = contextStore;
        this.byteBuddy = new ByteBuddy();
        this.fieldAccessorInterfaces = this.generateFieldAccessorInterfaces();
        this.fieldAccessorInterfacesInjector = this.bootstrapHelperInjector(this.fieldAccessorInterfaces.values());
        this.contextStoreImplementations = this.generateContextStoreImplementationClasses();
        this.contextStoreImplementationsInjector = this.bootstrapHelperInjector(this.contextStoreImplementations.values());
    }

    @Override
    public AgentBuilder.Identified.Extendable instrumentationTransformer(AgentBuilder.Identified.Extendable builder) {
        if (!this.contextStore.isEmpty()) {
            builder = builder.transform(FieldBackedProvider.getTransformerForAsmVisitor(this.getContextStoreReadsRewritingVisitor()));
            builder = this.injectHelpersIntoBootstrapClassloader(builder);
        }
        return builder;
    }

    private AsmVisitorWrapper getContextStoreReadsRewritingVisitor() {
        return new AsmVisitorWrapper(){

            public int mergeWriter(int flags) {
                return flags | 1;
            }

            public int mergeReader(int flags) {
                return flags;
            }

            public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
                return new ClassVisitor(458752, classVisitor){

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                        return new MethodVisitor(458752, mv){
                            private final Object[] stack;
                            private final int[] insnStack;
                            {
                                this.stack = new Object[]{null, null};
                                this.insnStack = new int[]{-1, -1, -1};
                            }

                            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                                this.pushOpcode(opcode);
                                if (Utils.getInternalName(CONTEXT_GET_METHOD.getDeclaringClass()).equals(owner) && CONTEXT_GET_METHOD.getName().equals(name) && Type.getMethodDescriptor((Method)CONTEXT_GET_METHOD).equals(descriptor)) {
                                    log.trace("Found context-store access in {}", (Object)FieldBackedProvider.this.instrumenterClass.getName());
                                    if (this.insnStack[0] == 184 && this.insnStack[1] == 18 && this.insnStack[2] == 18 && this.stack[0] instanceof Type && this.stack[1] instanceof Type) {
                                        String contextClassName = ((Type)this.stack[0]).getClassName();
                                        String keyClassName = ((Type)this.stack[1]).getClassName();
                                        TypeDescription contextStoreImplementationClass = FieldBackedProvider.this.getContextStoreImplementation(keyClassName, contextClassName);
                                        if (log.isTraceEnabled()) {
                                            log.trace("Rewriting context-store map fetch for instrumenter {}: {} -> {}", FieldBackedProvider.this.instrumenterClass.getName(), keyClassName, contextClassName);
                                        }
                                        if (contextStoreImplementationClass == null) {
                                            throw new IllegalStateException(String.format("Incorrect Context Api Usage detected. Cannot find map holder class for %s context %s. Was that class defined in contextStore for instrumentation %s?", keyClassName, contextClassName, FieldBackedProvider.this.instrumenterClass.getName()));
                                        }
                                        if (!contextClassName.equals(FieldBackedProvider.this.contextStore.get(keyClassName))) {
                                            throw new IllegalStateException(String.format("Incorrect Context Api Usage detected. Incorrect context class %s, expected %s for instrumentation %s", contextClassName, FieldBackedProvider.this.contextStore.get(keyClassName), FieldBackedProvider.this.instrumenterClass.getName()));
                                        }
                                        this.mv.visitMethodInsn(184, contextStoreImplementationClass.getInternalName(), GET_CONTEXT_STORE_METHOD.getName(), Type.getMethodDescriptor((Method)GET_CONTEXT_STORE_METHOD), false);
                                        return;
                                    }
                                    throw new IllegalStateException("Incorrect Context Api Usage detected. Key and context class must be class-literals. Example of correct usage: InstrumentationContext.get(Runnable.class, RunnableContext.class)");
                                }
                                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                            }

                            private void pushOpcode(int opcode) {
                                System.arraycopy(this.insnStack, 0, this.insnStack, 1, this.insnStack.length - 1);
                                this.insnStack[0] = opcode;
                            }

                            private void pushStack(Object o) {
                                System.arraycopy(this.stack, 0, this.stack, 1, this.stack.length - 1);
                                this.stack[0] = o;
                            }

                            public void visitInsn(int opcode) {
                                this.pushOpcode(opcode);
                                super.visitInsn(opcode);
                            }

                            public void visitJumpInsn(int opcode, Label label) {
                                this.pushOpcode(opcode);
                                super.visitJumpInsn(opcode, label);
                            }

                            public void visitIntInsn(int opcode, int operand) {
                                this.pushOpcode(opcode);
                                super.visitIntInsn(opcode, operand);
                            }

                            public void visitVarInsn(int opcode, int var) {
                                this.pushOpcode(opcode);
                                this.pushStack(var);
                                super.visitVarInsn(opcode, var);
                            }

                            public void visitLdcInsn(Object value) {
                                this.pushOpcode(18);
                                this.pushStack(value);
                                super.visitLdcInsn(value);
                            }
                        };
                    }
                };
            }
        };
    }

    private AgentBuilder.Identified.Extendable injectHelpersIntoBootstrapClassloader(AgentBuilder.Identified.Extendable builder) {
        builder = builder.transform(this.fieldAccessorInterfacesInjector);
        builder = builder.transform(this.contextStoreImplementationsInjector);
        return builder;
    }

    private AgentBuilder.Transformer bootstrapHelperInjector(final Collection<DynamicType.Unloaded<?>> helpers) {
        return new AgentBuilder.Transformer(){
            final HelperInjector injector;
            {
                this.injector = HelperInjector.forDynamicTypes(this.getClass().getSimpleName(), helpers);
            }

            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return this.injector.transform(builder, typeDescription, ClassLoaderMatcher.BOOTSTRAP_CLASSLOADER, module);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetContextMatchers() {
        Set<Map.Entry<String, String>> set = INSTALLED_CONTEXT_MATCHERS;
        synchronized (set) {
            INSTALLED_CONTEXT_MATCHERS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgentBuilder.Identified.Extendable additionalInstrumentation(AgentBuilder.Identified.Extendable builder) {
        if (FIELD_INJECTION_ENABLED) {
            for (Map.Entry<String, String> entry : this.contextStore.entrySet()) {
                Set<Map.Entry<String, String>> set = INSTALLED_CONTEXT_MATCHERS;
                synchronized (set) {
                    if (INSTALLED_CONTEXT_MATCHERS.contains(entry)) {
                        log.trace("Skipping builder for {} {}", (Object)this.instrumenterClass.getName(), (Object)entry);
                        continue;
                    }
                    log.trace("Making builder for {} {}", (Object)this.instrumenterClass.getName(), (Object)entry);
                    INSTALLED_CONTEXT_MATCHERS.add(entry);
                    builder = ((AgentBuilder.Identified.Narrowable)((AgentBuilder.Identified.Narrowable)builder.type((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()).and((ElementMatcher)AgentElementMatchers.safeHasSuperType((ElementMatcher)ElementMatchers.named((String)entry.getKey())))).and(FieldBackedProvider.safeToInjectFieldsMatcher())).and(InstrumentationModuleInstaller.NOT_DECORATOR_MATCHER)).transform((AgentBuilder.Transformer)NoOpTransformer.INSTANCE);
                    builder = this.injectHelpersIntoBootstrapClassloader(builder);
                    builder = builder.transform(FieldBackedProvider.getTransformerForAsmVisitor(this.getFieldInjectionVisitor(entry.getKey(), entry.getValue())));
                }
            }
        }
        return builder;
    }

    private static AgentBuilder.RawMatcher safeToInjectFieldsMatcher() {
        return new AgentBuilder.RawMatcher(){

            public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
                return classBeingRedefined == null || Arrays.asList(classBeingRedefined.getInterfaces()).contains(FieldBackedContextStoreAppliedMarker.class);
            }
        };
    }

    private AsmVisitorWrapper getFieldInjectionVisitor(final String keyClassName, final String contextClassName) {
        return new AsmVisitorWrapper(){

            public int mergeWriter(int flags) {
                return flags | 1;
            }

            public int mergeReader(int flags) {
                return flags;
            }

            public ClassVisitor wrap(final TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
                return new ClassVisitor(458752, classVisitor){
                    private final TypeDescription contextType;
                    private final String fieldName;
                    private final String getterMethodName;
                    private final String setterMethodName;
                    private final TypeDescription interfaceType;
                    private boolean foundField;
                    private boolean foundGetter;
                    private boolean foundSetter;
                    {
                        super(api, classVisitor);
                        this.contextType = new TypeDescription.ForLoadedType(Object.class);
                        this.fieldName = FieldBackedProvider.getContextFieldName(keyClassName);
                        this.getterMethodName = FieldBackedProvider.getContextGetterName(keyClassName);
                        this.setterMethodName = FieldBackedProvider.getContextSetterName(keyClassName);
                        this.interfaceType = FieldBackedProvider.this.getFieldAccessorInterface(keyClassName, contextClassName);
                        this.foundField = false;
                        this.foundGetter = false;
                        this.foundSetter = false;
                    }

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        if (interfaces == null) {
                            interfaces = new String[]{};
                        }
                        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(interfaces));
                        set.add(INJECTED_FIELDS_MARKER_CLASS_NAME);
                        set.add(this.interfaceType.getInternalName());
                        super.visit(version, access, name, signature, superName, set.toArray(new String[0]));
                    }

                    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                        if (name.equals(this.fieldName)) {
                            this.foundField = true;
                        }
                        return super.visitField(access, name, descriptor, signature, value);
                    }

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        if (name.equals(this.getterMethodName)) {
                            this.foundGetter = true;
                        }
                        if (name.equals(this.setterMethodName)) {
                            this.foundSetter = true;
                        }
                        return super.visitMethod(access, name, descriptor, signature, exceptions);
                    }

                    public void visitEnd() {
                        if (!this.foundField) {
                            this.cv.visitField(130, this.fieldName, this.contextType.getDescriptor(), null, null);
                        }
                        if (!this.foundGetter) {
                            this.addGetter();
                        }
                        if (!this.foundSetter) {
                            this.addSetter();
                        }
                        super.visitEnd();
                    }

                    private void addGetter() {
                        MethodVisitor mv = this.getAccessorMethodVisitor(this.getterMethodName);
                        mv.visitCode();
                        mv.visitVarInsn(25, 0);
                        mv.visitFieldInsn(180, instrumentedType.getInternalName(), this.fieldName, this.contextType.getDescriptor());
                        mv.visitInsn(176);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }

                    private void addSetter() {
                        MethodVisitor mv = this.getAccessorMethodVisitor(this.setterMethodName);
                        mv.visitCode();
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(25, 1);
                        mv.visitFieldInsn(181, instrumentedType.getInternalName(), this.fieldName, this.contextType.getDescriptor());
                        mv.visitInsn(177);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }

                    private MethodVisitor getAccessorMethodVisitor(String methodName) {
                        return this.cv.visitMethod(1, methodName, Utils.getMethodDefinition((TypeDefinition)this.interfaceType, methodName).getDescriptor(), null, null);
                    }
                };
            }
        };
    }

    private TypeDescription getContextStoreImplementation(String keyClassName, String contextClassName) {
        DynamicType.Unloaded<?> type = this.contextStoreImplementations.get(this.getContextStoreImplementationClassName(keyClassName, contextClassName));
        if (type == null) {
            return null;
        }
        return type.getTypeDescription();
    }

    private Map<String, DynamicType.Unloaded<?>> generateContextStoreImplementationClasses() {
        HashMap contextStoreImplementations = new HashMap(this.contextStore.size());
        for (Map.Entry<String, String> entry : this.contextStore.entrySet()) {
            DynamicType.Unloaded<?> type = this.makeContextStoreImplementationClass(entry.getKey(), entry.getValue());
            contextStoreImplementations.put(type.getTypeDescription().getName(), type);
        }
        return Collections.unmodifiableMap(contextStoreImplementations);
    }

    private DynamicType.Unloaded<?> makeContextStoreImplementationClass(String keyClassName, String contextClassName) {
        return this.byteBuddy.rebase(ContextStoreImplementationTemplate.class).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, TypeManifestation.FINAL}).name(this.getContextStoreImplementationClassName(keyClassName, contextClassName)).visit(this.getContextStoreImplementationVisitor(keyClassName, contextClassName)).make();
    }

    private AsmVisitorWrapper getContextStoreImplementationVisitor(final String keyClassName, final String contextClassName) {
        return new AsmVisitorWrapper(){

            public int mergeWriter(int flags) {
                return flags | 1;
            }

            public int mergeReader(int flags) {
                return flags;
            }

            public ClassVisitor wrap(final TypeDescription instrumentedType, ClassVisitor classVisitor, final Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
                return new ClassVisitor(458752, classVisitor){
                    private final TypeDescription accessorInterface;
                    private final String accessorInterfaceInternalName;
                    private final String instrumentedTypeInternalName;
                    private final boolean frames;
                    {
                        super(api, classVisitor);
                        this.accessorInterface = FieldBackedProvider.this.getFieldAccessorInterface(keyClassName, contextClassName);
                        this.accessorInterfaceInternalName = this.accessorInterface.getInternalName();
                        this.instrumentedTypeInternalName = instrumentedType.getInternalName();
                        this.frames = implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V6);
                    }

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        if ("realGet".equals(name)) {
                            this.generateRealGetMethod(name);
                            return null;
                        }
                        if ("realPut".equals(name)) {
                            this.generateRealPutMethod(name);
                            return null;
                        }
                        if ("realSynchronizeInstance".equals(name)) {
                            this.generateRealSynchronizeInstanceMethod(name);
                            return null;
                        }
                        return super.visitMethod(access, name, descriptor, signature, exceptions);
                    }

                    private void generateRealGetMethod(String name) {
                        String getterName = FieldBackedProvider.getContextGetterName(keyClassName);
                        Label elseLabel = new Label();
                        MethodVisitor mv = this.getMethodVisitor(name);
                        mv.visitCode();
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(193, this.accessorInterfaceInternalName);
                        mv.visitJumpInsn(153, elseLabel);
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(192, this.accessorInterfaceInternalName);
                        mv.visitMethodInsn(185, this.accessorInterfaceInternalName, getterName, Utils.getMethodDefinition((TypeDefinition)this.accessorInterface, getterName).getDescriptor(), true);
                        mv.visitInsn(176);
                        mv.visitLabel(elseLabel);
                        if (this.frames) {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(25, 1);
                        mv.visitMethodInsn(183, this.instrumentedTypeInternalName, "mapGet", Utils.getMethodDefinition((TypeDefinition)instrumentedType, "mapGet").getDescriptor(), false);
                        mv.visitInsn(176);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }

                    private void generateRealPutMethod(String name) {
                        String setterName = FieldBackedProvider.getContextSetterName(keyClassName);
                        Label elseLabel = new Label();
                        Label endLabel = new Label();
                        MethodVisitor mv = this.getMethodVisitor(name);
                        mv.visitCode();
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(193, this.accessorInterfaceInternalName);
                        mv.visitJumpInsn(153, elseLabel);
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(192, this.accessorInterfaceInternalName);
                        mv.visitVarInsn(25, 2);
                        mv.visitMethodInsn(185, this.accessorInterfaceInternalName, setterName, Utils.getMethodDefinition((TypeDefinition)this.accessorInterface, setterName).getDescriptor(), true);
                        mv.visitJumpInsn(167, endLabel);
                        mv.visitLabel(elseLabel);
                        if (this.frames) {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(25, 1);
                        mv.visitVarInsn(25, 2);
                        mv.visitMethodInsn(183, this.instrumentedTypeInternalName, "mapPut", Utils.getMethodDefinition((TypeDefinition)instrumentedType, "mapPut").getDescriptor(), false);
                        mv.visitLabel(endLabel);
                        if (this.frames) {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitInsn(177);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }

                    private void generateRealSynchronizeInstanceMethod(String name) {
                        MethodVisitor mv = this.getMethodVisitor(name);
                        mv.visitCode();
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(193, this.accessorInterfaceInternalName);
                        Label elseLabel = new Label();
                        mv.visitJumpInsn(153, elseLabel);
                        mv.visitVarInsn(25, 1);
                        mv.visitInsn(176);
                        mv.visitLabel(elseLabel);
                        if (this.frames) {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(25, 1);
                        mv.visitMethodInsn(183, this.instrumentedTypeInternalName, "mapSynchronizeInstance", Utils.getMethodDefinition((TypeDefinition)instrumentedType, "mapSynchronizeInstance").getDescriptor(), false);
                        mv.visitInsn(176);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }

                    private MethodVisitor getMethodVisitor(String methodName) {
                        return this.cv.visitMethod(2, methodName, Utils.getMethodDefinition((TypeDefinition)instrumentedType, methodName).getDescriptor(), null, null);
                    }
                };
            }
        };
    }

    private TypeDescription getFieldAccessorInterface(String keyClassName, String contextClassName) {
        DynamicType.Unloaded<?> type = this.fieldAccessorInterfaces.get(this.getContextAccessorInterfaceName(keyClassName, contextClassName));
        if (type == null) {
            return null;
        }
        return type.getTypeDescription();
    }

    private Map<String, DynamicType.Unloaded<?>> generateFieldAccessorInterfaces() {
        HashMap fieldAccessorInterfaces = new HashMap(this.contextStore.size());
        for (Map.Entry<String, String> entry : this.contextStore.entrySet()) {
            DynamicType.Unloaded<?> type = this.makeFieldAccessorInterface(entry.getKey(), entry.getValue());
            fieldAccessorInterfaces.put(type.getTypeDescription().getName(), type);
        }
        return Collections.unmodifiableMap(fieldAccessorInterfaces);
    }

    private DynamicType.Unloaded<?> makeFieldAccessorInterface(String keyClassName, String contextClassName) {
        TypeDescription.ForLoadedType contextType = new TypeDescription.ForLoadedType(Object.class);
        return this.byteBuddy.makeInterface().name(this.getContextAccessorInterfaceName(keyClassName, contextClassName)).defineMethod(FieldBackedProvider.getContextGetterName(keyClassName), (TypeDefinition)contextType, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withoutCode().defineMethod(FieldBackedProvider.getContextSetterName(keyClassName), (TypeDefinition)TypeDescription.VOID, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter((TypeDefinition)contextType, "value", new ModifierContributor.ForParameter[0]).withoutCode().make();
    }

    private static AgentBuilder.Transformer getTransformerForAsmVisitor(AsmVisitorWrapper visitor) {
        return (builder, typeDescription, classLoader, module) -> builder.visit(visitor);
    }

    private String getContextStoreImplementationClassName(String keyClassName, String contextClassName) {
        return DYNAMIC_CLASSES_PACKAGE + this.getClass().getSimpleName() + "$ContextStore$" + Utils.convertToInnerClassName(keyClassName) + "$" + Utils.convertToInnerClassName(contextClassName);
    }

    private String getContextAccessorInterfaceName(String keyClassName, String contextClassName) {
        return DYNAMIC_CLASSES_PACKAGE + this.getClass().getSimpleName() + "$ContextAccessor$" + Utils.convertToInnerClassName(keyClassName) + "$" + Utils.convertToInnerClassName(contextClassName);
    }

    private static String getContextFieldName(String keyClassName) {
        return "__opentelemetryContext$" + Utils.convertToInnerClassName(keyClassName);
    }

    private static String getContextGetterName(String keyClassName) {
        return "get" + FieldBackedProvider.getContextFieldName(keyClassName);
    }

    private static String getContextSetterName(String key) {
        return "set" + FieldBackedProvider.getContextFieldName(key);
    }

    static {
        try {
            CONTEXT_GET_METHOD = InstrumentationContext.class.getMethod("get", Class.class, Class.class);
            GET_CONTEXT_STORE_METHOD = ContextStoreImplementationTemplate.class.getMethod("getContextStore", Class.class, Class.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        FIELD_INJECTION_ENABLED = Config.get().getBooleanProperty("otel.javaagent.experimental.field-injection.enabled", true);
        INSTALLED_CONTEXT_MATCHERS = new HashSet<Map.Entry<String, String>>();
    }

    static enum NoOpTransformer implements AgentBuilder.Transformer
    {
        INSTANCE;


        public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
            return builder;
        }
    }

    private static final class ContextStoreImplementationTemplate
    implements ContextStore<Object, Object> {
        private static final ContextStoreImplementationTemplate INSTANCE = new ContextStoreImplementationTemplate((Cache<Object, Object>)Cache.newBuilder().setWeakKeys().build());
        private final Cache<Object, Object> map;

        private ContextStoreImplementationTemplate(Cache<Object, Object> map) {
            this.map = map;
        }

        public Object get(Object key) {
            return this.realGet(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object putIfAbsent(Object key, Object context) {
            Object existingContext = this.realGet(key);
            if (null != existingContext) {
                return existingContext;
            }
            Object object = this.realSynchronizeInstance(key);
            synchronized (object) {
                existingContext = this.realGet(key);
                if (null != existingContext) {
                    return existingContext;
                }
                this.realPut(key, context);
                return context;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object putIfAbsent(Object key, ContextStore.Factory<Object> contextFactory) {
            Object existingContext = this.realGet(key);
            if (null != existingContext) {
                return existingContext;
            }
            Object object = this.realSynchronizeInstance(key);
            synchronized (object) {
                existingContext = this.realGet(key);
                if (null != existingContext) {
                    return existingContext;
                }
                Object context = contextFactory.create();
                this.realPut(key, context);
                return context;
            }
        }

        public void put(Object key, Object context) {
            this.realPut(key, context);
        }

        private Object realGet(Object key) {
            return null;
        }

        private void realPut(Object key, Object value) {
        }

        private Object realSynchronizeInstance(Object key) {
            return null;
        }

        private Object mapGet(Object key) {
            return this.map.get(key);
        }

        private void mapPut(Object key, Object value) {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        }

        private Object mapSynchronizeInstance(Object key) {
            return this.map;
        }

        public static ContextStore getContextStore(Class keyClass, Class contextClass) {
            return INSTANCE;
        }
    }
}

