/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.extension.AgentExtension;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesConfigurer;
import io.opentelemetry.javaagent.instrumentation.api.internal.BootstrapPackagePrefixesHolder;
import io.opentelemetry.javaagent.spi.BootstrapPackagesProvider;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import io.opentelemetry.javaagent.tooling.Constants;
import io.opentelemetry.javaagent.tooling.ExtensionClassLoader;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.LoggingConfigurer;
import io.opentelemetry.javaagent.tooling.SafeServiceLoader;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.VersionLogger;
import io.opentelemetry.javaagent.tooling.config.ConfigInitializer;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredClassLoadersMatcher;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesBuilderImpl;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesMatcher;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInstaller {
    private static final Logger log;
    private static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    private static final String FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG = "otel.javaagent.experimental.force-synchronous-agent-listeners";
    private static final Map<String, List<Runnable>> CLASS_LOAD_CALLBACKS;
    private static volatile Instrumentation instrumentation;

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static void installBytebuddyAgent(Instrumentation inst) {
        AgentInstaller.logVersionInfo();
        Config config = Config.get();
        if (config.getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            List<AgentListener> agentListeners = SafeServiceLoader.loadOrdered(AgentListener.class);
            AgentInstaller.installBytebuddyAgent(inst, agentListeners);
        } else {
            log.debug("Tracing is disabled, not installing instrumentations.");
        }
    }

    public static ResettableClassFileTransformer installBytebuddyAgent(Instrumentation inst, Iterable<AgentListener> agentListeners) {
        Config config = Config.get();
        AgentInstaller.runBeforeAgentListeners(agentListeners, config);
        instrumentation = inst;
        FieldBackedProvider.resetContextMatchers();
        AgentBuilder agentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.DescriptionStrategy)AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with((AgentBuilder.PoolStrategy)AgentTooling.poolStrategy()).with((AgentBuilder.Listener)new ClassLoadListener()).with((AgentBuilder.LocationStrategy)AgentTooling.locationStrategy());
        agentBuilder = AgentInstaller.configureIgnoredTypes(config, agentBuilder);
        if (log.isDebugEnabled()) {
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.RedefinitionStrategy.Listener)new RedefinitionLoggingListener()).with((AgentBuilder.Listener)new TransformLoggingListener());
        }
        int numberOfLoadedExtensions = 0;
        for (AgentExtension agentExtension : SafeServiceLoader.loadOrdered(AgentExtension.class)) {
            log.debug("Loading extension {} [class {}]", (Object)agentExtension.extensionName(), (Object)agentExtension.getClass().getName());
            try {
                agentBuilder = agentExtension.extend(agentBuilder);
                ++numberOfLoadedExtensions;
            }
            catch (Exception | LinkageError e) {
                log.error("Unable to load extension {} [class {}]", new Object[]{agentExtension.extensionName(), agentExtension.getClass().getName(), e});
            }
        }
        log.debug("Installed {} extension(s)", (Object)numberOfLoadedExtensions);
        ResettableClassFileTransformer resettableClassFileTransformer = agentBuilder.installOn(inst);
        AgentInstaller.runAfterAgentListeners(agentListeners, config);
        return resettableClassFileTransformer;
    }

    private static void runBeforeAgentListeners(Iterable<AgentListener> agentListeners, Config config) {
        for (AgentListener agentListener : agentListeners) {
            agentListener.beforeAgent(config);
        }
    }

    private static AgentBuilder configureIgnoredTypes(Config config, AgentBuilder agentBuilder) {
        IgnoredTypesBuilderImpl builder = new IgnoredTypesBuilderImpl();
        for (IgnoredTypesConfigurer configurer : SafeServiceLoader.loadOrdered(IgnoredTypesConfigurer.class)) {
            configurer.configure(config, (IgnoredTypesBuilder)builder);
        }
        return (AgentBuilder)agentBuilder.ignore((ElementMatcher)ElementMatchers.any(), (ElementMatcher)new IgnoredClassLoadersMatcher(builder.buildIgnoredClassLoadersTrie())).or((ElementMatcher)new IgnoredTypesMatcher(builder.buildIgnoredTypesTrie()));
    }

    private static void runAfterAgentListeners(Iterable<AgentListener> agentListeners, Config config) {
        boolean shouldForceSynchronousAgentListenersCalls = Config.get().getBooleanProperty(FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG, false);
        if (!shouldForceSynchronousAgentListenersCalls && AgentInitializer.isJavaBefore9() && AgentInstaller.isAppUsingCustomLogManager()) {
            log.debug("Custom JUL LogManager detected: delaying AgentListener#afterAgent() calls");
            AgentInstaller.registerClassLoadCallback("java.util.logging.LogManager", new DelayedAfterAgentCallback(config, agentListeners));
        } else {
            for (AgentListener agentListener : agentListeners) {
                agentListener.afterAgent(config);
            }
        }
    }

    private static void addByteBuddyRawSetting() {
        String savedPropertyValue = System.getProperty("net.bytebuddy.raw");
        try {
            System.setProperty("net.bytebuddy.raw", "true");
            boolean rawTypes = TypeDescription.AbstractBase.RAW_TYPES;
            if (!rawTypes) {
                log.debug("Too late to enable {}", (Object)"net.bytebuddy.raw");
            }
        }
        finally {
            if (savedPropertyValue == null) {
                System.clearProperty("net.bytebuddy.raw");
            } else {
                System.setProperty("net.bytebuddy.raw", savedPropertyValue);
            }
        }
    }

    private static List<String> loadBootstrapPackagePrefixes() {
        ArrayList<String> bootstrapPackages = new ArrayList<String>(Constants.BOOTSTRAP_PACKAGE_PREFIXES);
        List<BootstrapPackagesProvider> bootstrapPackagesProviders = SafeServiceLoader.load(BootstrapPackagesProvider.class);
        for (BootstrapPackagesProvider provider : bootstrapPackagesProviders) {
            List packagePrefixes = provider.getPackagePrefixes();
            log.debug("Loaded bootstrap package prefixes from {}: {}", (Object)provider.getClass().getName(), (Object)packagePrefixes);
            bootstrapPackages.addAll(packagePrefixes);
        }
        return bootstrapPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoadCallback(String className, Runnable callback) {
        Map<String, List<Runnable>> map = CLASS_LOAD_CALLBACKS;
        synchronized (map) {
            List callbacks = CLASS_LOAD_CALLBACKS.computeIfAbsent(className, k -> new ArrayList());
            callbacks.add(callback);
        }
    }

    private static boolean isAppUsingCustomLogManager() {
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            log.debug("Found JBoss: {}; assuming app is using custom LogManager", (Object)jbossHome);
            return true;
        }
        String customLogManager = System.getProperty("java.util.logging.manager");
        if (customLogManager != null) {
            log.debug("Detected custom LogManager configuration: java.util.logging.manager={}", (Object)customLogManager);
            boolean onSysClasspath = ClassLoader.getSystemResource(Utils.getResourceName(customLogManager)) != null;
            log.debug("Class {} is on system classpath: {}delaying AgentInstaller#afterAgent()", (Object)customLogManager, (Object)(onSysClasspath ? "not " : ""));
            return !onSysClasspath;
        }
        return false;
    }

    private static void logVersionInfo() {
        VersionLogger.logAllVersions();
        log.debug("{} loaded on {}", (Object)AgentInstaller.class.getName(), (Object)AgentInstaller.class.getClassLoader());
    }

    private AgentInstaller() {
    }

    static {
        CLASS_LOAD_CALLBACKS = new HashMap<String, List<Runnable>>();
        LoggingConfigurer.configureLogger();
        log = LoggerFactory.getLogger(AgentInstaller.class);
        AgentInstaller.addByteBuddyRawSetting();
        BootstrapPackagePrefixesHolder.setBoostrapPackagePrefixes(AgentInstaller.loadBootstrapPackagePrefixes());
        ConfigInitializer.initialize();
        Proxy.class.getName();
        ForkJoinPool.class.getName();
        AtomicReferenceArray.class.getName();
    }

    private static class RedefinitionDiscoveryStrategy
    implements AgentBuilder.RedefinitionStrategy.DiscoveryStrategy {
        private static final AgentBuilder.RedefinitionStrategy.DiscoveryStrategy delegate = AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE;

        private RedefinitionDiscoveryStrategy() {
        }

        public Iterable<Iterable<Class<?>>> resolve(Instrumentation instrumentation) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(delegate.resolve(instrumentation)).map(RedefinitionDiscoveryStrategy::filterClasses).iterator();
        }

        private static Iterable<Class<?>> filterClasses(Iterable<Class<?>> classes) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(classes).filter(c -> !RedefinitionDiscoveryStrategy.isIgnored(c)).iterator();
        }

        private static <T> Stream<T> streamOf(Iterable<T> iterable) {
            return StreamSupport.stream(iterable.spliterator(), false);
        }

        private static boolean isIgnored(Class<?> c) {
            ClassLoader cl = c.getClassLoader();
            if (cl instanceof AgentClassLoader || cl instanceof ExtensionClassLoader) {
                return true;
            }
            return HelperInjector.isInjectedClass(c);
        }
    }

    private static class ClassLoadListener
    implements AgentBuilder.Listener {
        private ClassLoadListener() {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b, DynamicType dynamicType) {
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onError(String s, ClassLoader classLoader, JavaModule javaModule, boolean b, Throwable throwable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
            Map map = CLASS_LOAD_CALLBACKS;
            synchronized (map) {
                List callbacks = (List)CLASS_LOAD_CALLBACKS.get(typeName);
                if (callbacks != null) {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                }
            }
        }
    }

    private static class DelayedAfterAgentCallback
    implements Runnable {
        private final Iterable<AgentListener> agentListeners;
        private final Config config;

        private DelayedAfterAgentCallback(Config config, Iterable<AgentListener> agentListeners) {
            this.agentListeners = agentListeners;
            this.config = config;
        }

        @Override
        public void run() {
            Thread thread = new Thread(this::runAgentListeners);
            thread.setName("delayed-agent-listeners");
            thread.setDaemon(true);
            thread.start();
        }

        private void runAgentListeners() {
            for (AgentListener agentListener : this.agentListeners) {
                try {
                    agentListener.afterAgent(this.config);
                }
                catch (RuntimeException e) {
                    log.error("Failed to execute {}", (Object)agentListener.getClass().getName(), (Object)e);
                }
            }
        }
    }

    static class TransformLoggingListener
    implements AgentBuilder.Listener {
        private static final TransformSafeLogger log = TransformSafeLogger.getLogger(TransformLoggingListener.class);

        TransformLoggingListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to handle {} for transformation on classloader {}", typeName, classLoader, throwable);
            }
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            log.debug("Transformed {} -- {}", (Object)typeDescription.getName(), (Object)classLoader);
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }
    }

    static class RedefinitionLoggingListener
    implements AgentBuilder.RedefinitionStrategy.Listener {
        private static final Logger log = LoggerFactory.getLogger(RedefinitionLoggingListener.class);

        RedefinitionLoggingListener() {
        }

        public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
        }

        public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while retransforming {} classes: {}", new Object[]{batch.size(), batch, throwable});
            }
            return Collections.emptyList();
        }

        public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
        }
    }
}

