/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.ignore;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesConfigurer;
import io.opentelemetry.javaagent.tooling.ExtensionClassLoader;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;

@AutoService(value={IgnoredTypesConfigurer.class})
public class GlobalIgnoredTypesConfigurer
implements IgnoredTypesConfigurer {
    public void configure(IgnoredTypesBuilder builder, ConfigProperties config) {
        GlobalIgnoredTypesConfigurer.configureIgnoredTypes(builder);
        GlobalIgnoredTypesConfigurer.configureIgnoredClassLoaders(builder);
        GlobalIgnoredTypesConfigurer.configureIgnoredTasks(builder);
    }

    private static void configureIgnoredTypes(IgnoredTypesBuilder builder) {
        builder.ignoreClass("org.gradle.").ignoreClass("net.bytebuddy.").ignoreClass("jdk.").ignoreClass("org.aspectj.").ignoreClass("datadog.").ignoreClass("com.intellij.rt.debugger.").ignoreClass("com.p6spy.").ignoreClass("com.dynatrace.").ignoreClass("com.jloadtrace.").ignoreClass("com.appdynamics.").ignoreClass("com.newrelic.agent.").ignoreClass("com.newrelic.api.agent.").ignoreClass("com.nr.agent.").ignoreClass("com.singularity.").ignoreClass("com.jinspired.").ignoreClass("org.jinspired.");
        builder.allowClass("jdk.internal.net.http.");
        builder.ignoreClass("org.groovy.").ignoreClass("org.apache.groovy.").ignoreClass("org.codehaus.groovy.").allowClass("org.codehaus.groovy.runtime.");
        builder.ignoreClass("clojure.").ignoreClass("$fn__");
        builder.ignoreClass("io.opentelemetry.javaagent.bootstrap.");
        builder.ignoreClass("io.opentelemetry.javaagent.shaded.");
        builder.ignoreClass("java.").allowClass("java.net.URL").allowClass("java.net.HttpURLConnection").allowClass("java.net.URLClassLoader").allowClass("java.rmi.").allowClass("java.util.concurrent.").allowClass("java.lang.reflect.Proxy").allowClass("java.lang.ClassLoader").ignoreClass("java.lang.ClassLoader$").allowClass("java.lang.invoke.InnerClassLambdaMetafactory").allowClass("java.util.logging.").ignoreClass("java.util.logging.LogManager$Cleaner");
        builder.ignoreClass("com.sun.").allowClass("com.sun.messaging.").allowClass("com.sun.jersey.api.client").allowClass("com.sun.appserv").allowClass("com.sun.faces").allowClass("com.sun.xml.ws");
        builder.ignoreClass("sun.").allowClass("sun.net.www.protocol.").allowClass("sun.rmi.server").allowClass("sun.rmi.transport").allowClass("sun.net.www.http.HttpClient");
        builder.ignoreClass("org.slf4j.");
        builder.ignoreClass("org.springframework.core.$Proxy").ignoreClass("$HttpServletRequest_");
    }

    private static void configureIgnoredClassLoaders(IgnoredTypesBuilder builder) {
        builder.ignoreClassLoader("groovy.lang.GroovyClassLoader").ignoreClassLoader("org.codehaus.groovy.runtime.callsite.CallSiteClassLoader").ignoreClassLoader("org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyClassLoader").ignoreClassLoader("sun.reflect.DelegatingClassLoader").ignoreClassLoader("jdk.internal.reflect.DelegatingClassLoader").ignoreClassLoader("clojure.lang.DynamicClassLoader").ignoreClassLoader("org.apache.cxf.common.util.ASMHelper$TypeHelperClassLoader").ignoreClassLoader("org.springframework.context.support.ContextTypeMatchClassLoader$ContextOverridingClassLoader").ignoreClassLoader("sun.misc.Launcher$ExtClassLoader").ignoreClassLoader("org.openjdk.nashorn.internal.runtime.ScriptLoader").ignoreClassLoader("org.codehaus.janino.ByteArrayClassLoader").ignoreClassLoader("org.eclipse.persistence.internal.jaxb.JaxbClassLoader").ignoreClassLoader(AgentClassLoader.class.getName()).ignoreClassLoader(ExtensionClassLoader.class.getName());
        builder.ignoreClassLoader("datadog.").ignoreClassLoader("com.dynatrace.").ignoreClassLoader("com.appdynamics.").ignoreClassLoader("com.singularity.").ignoreClassLoader("com.newrelic.agent.").ignoreClassLoader("com.newrelic.api.agent.").ignoreClassLoader("com.nr.agent.");
    }

    private static void configureIgnoredTasks(IgnoredTypesBuilder builder) {
        builder.ignoreTaskClass("java.util.concurrent.ForkJoinWorkerThread");
        builder.ignoreTaskClass("java.util.concurrent.ThreadPoolExecutor$Worker");
        builder.ignoreTaskClass("org.apache.tomcat.util.net.NioEndpoint$SocketProcessor");
        builder.ignoreTaskClass("org.eclipse.jetty.server.HttpConnection");
        builder.ignoreTaskClass("org.eclipse.jetty.io.nio.SelectChannelEndPoint$");
        builder.ignoreTaskClass("io.netty.util.concurrent.SingleThreadEventExecutor$");
        builder.ignoreTaskClass("io.prestosql.jdbc.$internal.okhttp3.ConnectionPool$");
        builder.ignoreTaskClass("io.trino.jdbc.$internal.okhttp3.ConnectionPool$");
    }
}

