/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.matcher;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.muzzle.Reference;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.ReferenceMatcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.bytebuddy.dynamic.ClassFileLocator;

public final class MuzzleGradlePluginUtil {
    public static void assertInstrumentationMuzzled(ClassLoader agentClassLoader, ClassLoader userClassLoader, boolean assertPass) throws Exception {
        int validatedModulesCount = 0;
        for (InstrumentationModule instrumentationModule : ServiceLoader.load(InstrumentationModule.class, agentClassLoader)) {
            boolean passed;
            ReferenceMatcher muzzle = new ReferenceMatcher(Arrays.asList(instrumentationModule.getMuzzleHelperClassNames()), instrumentationModule.getMuzzleReferences(), arg_0 -> ((InstrumentationModule)instrumentationModule).isHelperClass(arg_0));
            List<Mismatch> mismatches = muzzle.getMismatchedReferenceSources(userClassLoader);
            boolean classLoaderMatch = instrumentationModule.classLoaderMatcher().matches((Object)userClassLoader);
            boolean bl = passed = mismatches.isEmpty() && classLoaderMatch;
            if (passed && !assertPass) {
                System.err.println("MUZZLE PASSED " + instrumentationModule.getClass().getSimpleName() + " BUT FAILURE WAS EXPECTED");
                throw new RuntimeException("Instrumentation unexpectedly passed Muzzle validation");
            }
            if (!passed && assertPass) {
                System.err.println("FAILED MUZZLE VALIDATION: " + instrumentationModule.getClass().getName() + " mismatches:");
                if (!classLoaderMatch) {
                    System.err.println("-- classloader mismatch");
                }
                for (Mismatch mismatch : mismatches) {
                    System.err.println("-- " + mismatch);
                }
                throw new RuntimeException("Instrumentation failed Muzzle validation");
            }
            ++validatedModulesCount;
        }
        if (assertPass) {
            for (InstrumentationModule instrumentationModule : ServiceLoader.load(InstrumentationModule.class, agentClassLoader)) {
                try {
                    List<String> allHelperClasses = Arrays.asList(instrumentationModule.getMuzzleHelperClassNames());
                    if (allHelperClasses.isEmpty()) continue;
                    new HelperInjector(MuzzleGradlePluginUtil.class.getSimpleName(), MuzzleGradlePluginUtil.createHelperMap(allHelperClasses, agentClassLoader)).transform(null, null, userClassLoader, null);
                }
                catch (Exception e) {
                    System.err.println("FAILED HELPER INJECTION. Are Helpers being injected in the correct order?");
                    throw e;
                }
            }
        }
        if (validatedModulesCount == 0) {
            String errorMessage = "Did not found any InstrumentationModule to validate!";
            System.err.println(errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    private static Map<String, byte[]> createHelperMap(Collection<String> helperClassNames, ClassLoader agentClassLoader) throws IOException {
        LinkedHashMap<String, byte[]> helperMap = new LinkedHashMap<String, byte[]>(helperClassNames.size());
        for (String helperName : helperClassNames) {
            ClassFileLocator locator = ClassFileLocator.ForClassLoader.of((ClassLoader)agentClassLoader);
            byte[] classBytes = locator.locate(helperName).resolve();
            helperMap.put(helperName, classBytes);
        }
        return helperMap;
    }

    public static void printMuzzleReferences(ClassLoader instrumentationClassLoader) {
        for (InstrumentationModule instrumentationModule : ServiceLoader.load(InstrumentationModule.class, instrumentationClassLoader)) {
            try {
                System.out.println(instrumentationModule.getClass().getName());
                for (Reference ref : instrumentationModule.getMuzzleReferences()) {
                    System.out.println(MuzzleGradlePluginUtil.prettyPrint("  ", ref));
                }
            }
            catch (Exception e) {
                String message = "Unexpected exception printing references for " + instrumentationModule.getClass().getName();
                System.out.println(message);
                throw new RuntimeException(message, e);
            }
        }
    }

    private static String prettyPrint(String prefix, Reference ref) {
        StringBuilder builder = new StringBuilder(prefix).append(ref.getClassName());
        if (ref.getSuperName() != null) {
            builder.append(" extends<").append(ref.getSuperName()).append(">");
        }
        if (!ref.getInterfaces().isEmpty()) {
            builder.append(" implements ");
            for (String iface : ref.getInterfaces()) {
                builder.append(" <").append(iface).append(">");
            }
        }
        for (Reference.Source source : ref.getSources()) {
            builder.append("\n").append(prefix).append(prefix);
            builder.append("Source: ").append(source.toString());
        }
        for (Reference.Field field : ref.getFields()) {
            builder.append("\n").append(prefix).append(prefix);
            builder.append("Field: ");
            for (Reference.Flag flag : field.getFlags()) {
                builder.append(flag).append(" ");
            }
            builder.append(field.toString());
        }
        for (Reference.Method method : ref.getMethods()) {
            builder.append("\n").append(prefix).append(prefix);
            builder.append("Method: ");
            for (Reference.Flag flag : method.getFlags()) {
                builder.append(flag).append(" ");
            }
            builder.append(method.toString());
        }
        return builder.toString();
    }

    private MuzzleGradlePluginUtil() {
    }
}

