/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.collector;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import io.opentelemetry.javaagent.extension.muzzle.Reference;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationClassPredicate;
import io.opentelemetry.javaagent.tooling.muzzle.collector.ReferenceCollectingClassVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReferenceCollector {
    private final Map<String, Reference> references = new LinkedHashMap<String, Reference>();
    private final MutableGraph<String> helperSuperClassGraph = GraphBuilder.directed().build();
    private final Map<String, String> contextStoreClasses = new LinkedHashMap<String, String>();
    private final Set<String> visitedClasses = new HashSet<String>();
    private final InstrumentationClassPredicate instrumentationClassPredicate;
    private static final Pattern AWS_SDK_V2_SERVICE_INTERCEPTOR_SPI = Pattern.compile("software/amazon/awssdk/services/\\w+(/\\w+)?/execution.interceptors");
    private static final Pattern AWS_SDK_V1_SERVICE_INTERCEPTOR_SPI = Pattern.compile("com/amazonaws/services/\\w+(/\\w+)?/request.handler2s");

    public ReferenceCollector(Predicate<String> libraryInstrumentationPredicate) {
        this.instrumentationClassPredicate = new InstrumentationClassPredicate(libraryInstrumentationPredicate);
    }

    public void collectReferencesFromResource(String resource) {
        if (!this.isSpiFile(resource)) {
            return;
        }
        ArrayList<String> spiImplementations = new ArrayList<String>();
        try (InputStream stream = ReferenceCollector.getResourceStream(resource);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while (reader.ready()) {
                String line = reader.readLine();
                if (Strings.isNullOrEmpty((String)line)) continue;
                spiImplementations.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading resource " + resource, e);
        }
        this.visitClassesAndCollectReferences(spiImplementations, false);
    }

    private boolean isSpiFile(String resource) {
        return resource.startsWith("META-INF/services/") || resource.equals("software/amazon/awssdk/global/handlers/execution.interceptors") || resource.equals("com/amazonaws/global/handlers/request.handler2s") || AWS_SDK_V2_SERVICE_INTERCEPTOR_SPI.matcher(resource).matches() || AWS_SDK_V1_SERVICE_INTERCEPTOR_SPI.matcher(resource).matches();
    }

    public void collectReferencesFromAdvice(String adviceClassName) {
        this.visitClassesAndCollectReferences(Collections.singleton(adviceClassName), true);
    }

    private void visitClassesAndCollectReferences(Collection<String> startingClasses, boolean startsFromAdviceClass) {
        ArrayDeque<String> instrumentationQueue = new ArrayDeque<String>(startingClasses);
        boolean isAdviceClass = startsFromAdviceClass;
        while (!instrumentationQueue.isEmpty()) {
            String visitedClassName = (String)instrumentationQueue.remove();
            this.visitedClasses.add(visitedClassName);
            try (InputStream in = ReferenceCollector.getClassFileStream(visitedClassName);){
                ReferenceCollectingClassVisitor cv = new ReferenceCollectingClassVisitor(this.instrumentationClassPredicate, isAdviceClass);
                ClassReader reader = new ClassReader(in);
                reader.accept((ClassVisitor)cv, 4);
                for (Map.Entry<String, Reference> entry : cv.getReferences().entrySet()) {
                    String refClassName = entry.getKey();
                    Reference reference = entry.getValue();
                    if (!this.visitedClasses.contains(refClassName) && this.instrumentationClassPredicate.isInstrumentationClass(refClassName)) {
                        instrumentationQueue.add(refClassName);
                    }
                    this.addReference(refClassName, reference);
                }
                this.collectHelperClasses(isAdviceClass, visitedClassName, cv.getHelperClasses(), cv.getHelperSuperClasses());
                this.contextStoreClasses.putAll(cv.getContextStoreClasses());
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading class " + visitedClassName, e);
            }
            if (!isAdviceClass) continue;
            isAdviceClass = false;
        }
    }

    private static InputStream getClassFileStream(String className) throws IOException {
        return ReferenceCollector.getResourceStream(Utils.getResourceName(className));
    }

    private static InputStream getResourceStream(String resource) throws IOException {
        URLConnection connection = ((URL)Preconditions.checkNotNull((Object)ReferenceCollector.class.getClassLoader().getResource(resource), (String)"Couldn't find resource %s", (Object)resource)).openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    private void addReference(String refClassName, Reference reference) {
        if (this.references.containsKey(refClassName)) {
            this.references.put(refClassName, this.references.get(refClassName).merge(reference));
        } else {
            this.references.put(refClassName, reference);
        }
    }

    private void collectHelperClasses(boolean isAdviceClass, String className, Set<String> helperClasses, Set<String> helperSuperClasses) {
        for (String helperClass : helperClasses) {
            this.helperSuperClassGraph.addNode((Object)helperClass);
        }
        if (!isAdviceClass) {
            for (String helperSuperClass : helperSuperClasses) {
                this.helperSuperClassGraph.putEdge((Object)className, (Object)helperSuperClass);
            }
        }
    }

    public Map<String, Reference> getReferences() {
        return this.references;
    }

    public void prune() {
        Set<Reference> helperClassesParticipatingInLibrarySuperType = this.getHelperClassesParticipatingInLibrarySuperType();
        Iterator<Reference> i = this.references.values().iterator();
        while (i.hasNext()) {
            Reference reference = i.next();
            if (this.instrumentationClassPredicate.isProvidedByLibrary(reference.getClassName())) continue;
            if (helperClassesParticipatingInLibrarySuperType.contains(reference)) {
                reference.getMethods().removeIf(method -> method.getName().equals("<init>") || method.getFlags().contains(Reference.Flag.VisibilityFlag.PRIVATE) || method.getFlags().contains(Reference.Flag.OwnershipFlag.STATIC));
                continue;
            }
            i.remove();
        }
    }

    private Set<Reference> getHelperClassesParticipatingInLibrarySuperType() {
        HashSet<Reference> helperClassesParticipatingInLibrarySuperType = new HashSet<Reference>();
        for (Reference reference : this.getHelperClassesWithLibrarySuperType()) {
            this.addSuperTypesThatAreAlsoHelperClasses(reference.getClassName(), helperClassesParticipatingInLibrarySuperType);
        }
        return helperClassesParticipatingInLibrarySuperType;
    }

    private Set<Reference> getHelperClassesWithLibrarySuperType() {
        HashSet<Reference> helperClassesWithLibrarySuperType = new HashSet<Reference>();
        for (Reference reference : this.references.values()) {
            if (!this.instrumentationClassPredicate.isInstrumentationClass(reference.getClassName()) || !this.hasLibrarySuperType(reference.getClassName())) continue;
            helperClassesWithLibrarySuperType.add(reference);
        }
        return helperClassesWithLibrarySuperType;
    }

    private void addSuperTypesThatAreAlsoHelperClasses(@Nullable String className, Set<Reference> superTypes) {
        if (className != null && this.instrumentationClassPredicate.isInstrumentationClass(className)) {
            Reference reference = this.references.get(className);
            superTypes.add(reference);
            this.addSuperTypesThatAreAlsoHelperClasses(reference.getSuperName(), superTypes);
            for (String superType : reference.getInterfaces()) {
                this.addSuperTypesThatAreAlsoHelperClasses(superType, superTypes);
            }
        }
    }

    private boolean hasLibrarySuperType(@Nullable String typeName) {
        if (typeName == null || typeName.startsWith("java.")) {
            return false;
        }
        if (this.instrumentationClassPredicate.isProvidedByLibrary(typeName)) {
            return true;
        }
        Reference reference = this.references.get(typeName);
        if (this.hasLibrarySuperType(reference.getSuperName())) {
            return true;
        }
        for (String type : reference.getInterfaces()) {
            if (!this.hasLibrarySuperType(type)) continue;
            return true;
        }
        return false;
    }

    public List<String> getSortedHelperClasses() {
        MutableGraph dependencyGraph = Graphs.copyOf((Graph)Graphs.transpose(this.helperSuperClassGraph));
        ArrayList<String> helperClasses = new ArrayList<String>(dependencyGraph.nodes().size());
        Queue<String> helpersWithNoDeps = ReferenceCollector.findAllHelperClassesWithoutDependencies((Graph<String>)dependencyGraph);
        while (!helpersWithNoDeps.isEmpty()) {
            String helperClass = helpersWithNoDeps.remove();
            helperClasses.add(helperClass);
            HashSet dependencies = new HashSet(dependencyGraph.successors((Object)helperClass));
            for (String dependency : dependencies) {
                dependencyGraph.removeEdge((Object)helperClass, (Object)dependency);
                if (!dependencyGraph.predecessors((Object)dependency).isEmpty()) continue;
                helpersWithNoDeps.add(dependency);
            }
        }
        return helperClasses;
    }

    private static Queue<String> findAllHelperClassesWithoutDependencies(Graph<String> dependencyGraph) {
        LinkedList<String> helpersWithNoDeps = new LinkedList<String>();
        for (String helperClass : dependencyGraph.nodes()) {
            if (!dependencyGraph.predecessors((Object)helperClass).isEmpty()) continue;
            helpersWithNoDeps.add(helperClass);
        }
        return helpersWithNoDeps;
    }

    public Map<String, String> getContextStoreClasses() {
        return this.contextStoreClasses;
    }
}

