/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class ConfigurationFileLoader
implements Supplier<Map<String, String>> {
    private static final Logger logger = Logger.getLogger(ConfigurationFileLoader.class.getName());
    static final String CONFIGURATION_FILE_PROPERTY = "otel.javaagent.configuration-file";

    @Override
    public Map<String, String> get() {
        String configurationFilePath = ConfigPropertiesUtil.getString((String)CONFIGURATION_FILE_PROPERTY);
        if (configurationFilePath == null) {
            return Collections.emptyMap();
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            logger.log(Level.SEVERE, "Configuration file \"{0}\" not found.", configurationFilePath);
            return Collections.emptyMap();
        }
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configurationFile), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fnf) {
            logger.log(Level.SEVERE, "Configuration file \"{0}\" not found.", configurationFilePath);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Configuration file \"{0}\" cannot be accessed or correctly parsed.", configurationFilePath);
        }
        return properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
    }
}

