/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.bytebuddy.matcher;

import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.SafeHasSuperTypeMatcher;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

class HasSuperMethodMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super MethodDescription> matcher;

    public HasSuperMethodMatcher(ElementMatcher<? super MethodDescription> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(MethodDescription target) {
        if (target.isConstructor()) {
            return false;
        }
        ElementMatcher.Junction signatureMatcher = ElementMatchers.hasSignature((MethodDescription.SignatureToken)target.asSignatureToken());
        TypeDefinition declaringType = target.getDeclaringType();
        HashSet<TypeDefinition> checkedInterfaces = new HashSet<TypeDefinition>(8);
        while (declaringType != null) {
            for (MethodDescription methodDescription : declaringType.getDeclaredMethods()) {
                if (!signatureMatcher.matches((Object)methodDescription) || !this.matcher.matches((Object)methodDescription)) continue;
                return true;
            }
            if (this.matchesInterface(declaringType.getInterfaces(), (ElementMatcher.Junction<MethodDescription>)signatureMatcher, checkedInterfaces)) {
                return true;
            }
            declaringType = SafeHasSuperTypeMatcher.safeGetSuperClass(declaringType);
        }
        return false;
    }

    private boolean matchesInterface(TypeList.Generic interfaces, ElementMatcher.Junction<MethodDescription> signatureMatcher, Set<TypeDefinition> checkedInterfaces) {
        for (TypeDefinition type : interfaces) {
            if (!checkedInterfaces.add(type)) continue;
            for (MethodDescription methodDescription : type.getDeclaredMethods()) {
                if (!signatureMatcher.matches((Object)methodDescription) || !this.matcher.matches((Object)methodDescription)) continue;
                return true;
            }
            if (!this.matchesInterface(type.getInterfaces(), signatureMatcher, checkedInterfaces)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "hasSuperMethodMatcher(" + this.matcher + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HasSuperMethodMatcher)) {
            return false;
        }
        HasSuperMethodMatcher other = (HasSuperMethodMatcher)((Object)obj);
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }
}

