/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TransformSafeLogger {
    private static final boolean ENABLE_TRANSFORM_SAFE_LOGGING = Boolean.getBoolean("otel.javaagent.testing.transform-safe-logging.enabled");
    private static final BlockingQueue<LogMessage> logMessageQueue;
    private final Logger logger;

    public static TransformSafeLogger getLogger(Class<?> clazz) {
        return new TransformSafeLogger(LoggerFactory.getLogger(clazz));
    }

    private TransformSafeLogger(Logger logger) {
        this.logger = logger;
    }

    public void debug(String format, Object arg) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.DEBUG, this.logger, format, new Object[]{arg}));
        } else {
            this.logger.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.DEBUG, this.logger, format, new Object[]{arg1, arg2}));
        } else {
            this.logger.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.DEBUG, this.logger, format, arguments));
        } else {
            this.logger.debug(format, arguments);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void trace(String format, Object arg) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.TRACE, this.logger, format, new Object[]{arg}));
        } else {
            this.logger.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.TRACE, this.logger, format, new Object[]{arg1, arg2}));
        } else {
            this.logger.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.TRACE, this.logger, format, arguments));
        } else {
            this.logger.trace(format, arguments);
        }
    }

    public void warn(String format, Object arg) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.WARN, this.logger, format, new Object[]{arg}));
        } else {
            this.logger.warn(format, arg);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.WARN, this.logger, format, new Object[]{arg1, arg2}));
        } else {
            this.logger.warn(format, arg1, arg2);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (logMessageQueue != null) {
            logMessageQueue.offer(new LogMessage(Level.WARN, this.logger, format, arguments));
        } else {
            this.logger.warn(format, arguments);
        }
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    static {
        if (ENABLE_TRANSFORM_SAFE_LOGGING) {
            logMessageQueue = new ArrayBlockingQueue<LogMessage>(1000);
            Thread thread = new Thread(new LogMessageQueueReader());
            thread.setName("otel-javaagent-transform-safe-logger");
            thread.setDaemon(true);
            thread.start();
        } else {
            logMessageQueue = null;
        }
    }

    private static class LogMessage {
        private final Level level;
        private final Logger logger;
        private final String format;
        private final Object[] arguments;

        private LogMessage(Level level, Logger logger, String format, Object ... arguments) {
            this.level = level;
            this.logger = logger;
            this.format = format;
            this.arguments = arguments;
        }
    }

    private static class LogMessageQueueReader
    implements Runnable {
        private LogMessageQueueReader() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    LogMessage logMessage;
                    if ((logMessage = (LogMessage)logMessageQueue.take()).level == Level.DEBUG) {
                        logMessage.logger.debug(logMessage.format, logMessage.arguments);
                        continue;
                    }
                    if (logMessage.level == Level.TRACE) {
                        logMessage.logger.trace(logMessage.format, logMessage.arguments);
                        continue;
                    }
                    logMessage.logger.warn("level {} not implemented yet in TransformSafeLogger", (Object)logMessage.level);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

