/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.collector;

import io.opentelemetry.javaagent.instrumentation.api.WeakMap;
import io.opentelemetry.javaagent.tooling.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.muzzle.collector.MuzzleCodeGenerator;
import java.util.Collections;
import java.util.WeakHashMap;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;

public class MuzzleCodeGenerationPlugin
implements Plugin {
    private static final TypeDescription instrumentationModuleType;

    public boolean matches(TypeDescription target) {
        if (target.isAbstract()) {
            return false;
        }
        boolean isInstrumentationModule = false;
        for (TypeDescription.Generic instrumentation = target.getSuperClass(); instrumentation != null; instrumentation = instrumentation.getSuperClass()) {
            if (!instrumentation.equals(instrumentationModuleType)) continue;
            isInstrumentationModule = true;
            break;
        }
        return isInstrumentationModule;
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return builder.visit((AsmVisitorWrapper)new MuzzleCodeGenerator());
    }

    public void close() {
    }

    static {
        WeakMap.Provider.registerIfAbsent((WeakMap.Implementation)new WeakMap.Implementation(){

            public <K, V> WeakMap<K, V> get() {
                return new WeakMap.MapAdapter(Collections.synchronizedMap(new WeakHashMap()));
            }
        });
        instrumentationModuleType = new TypeDescription.ForLoadedType(InstrumentationModule.class);
    }
}

