/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchLogger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    public static final PatchLogger global = new PatchLogger("global");
    private final Logger slf4jLogger;
    private ResourceBundle resourceBundle;

    public static PatchLogger getLogger(String name) {
        return new PatchLogger(name);
    }

    public static PatchLogger getLogger(String name, String resourceBundleName) {
        return new PatchLogger(name);
    }

    private PatchLogger(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    PatchLogger(Logger logger) {
        this.slf4jLogger = logger;
    }

    Logger getSlf4jLogger() {
        return this.slf4jLogger;
    }

    public String getName() {
        return this.slf4jLogger.getName();
    }

    public void severe(String msg) {
        this.slf4jLogger.error(msg);
    }

    public void warning(String msg) {
        this.slf4jLogger.warn(msg);
    }

    public void info(String msg) {
        this.slf4jLogger.info(msg);
    }

    public void config(String msg) {
        this.slf4jLogger.info(msg);
    }

    public void fine(String msg) {
        this.slf4jLogger.debug(msg);
    }

    public void finer(String msg) {
        this.slf4jLogger.trace(msg);
    }

    public void finest(String msg) {
        this.slf4jLogger.trace(msg);
    }

    public void log(LogRecord record) {
        Level level = record.getLevel();
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.slf4jLogger.isErrorEnabled()) {
                this.slf4jLogger.error(PatchLogger.getMessage(record), record.getThrown());
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.slf4jLogger.isWarnEnabled()) {
                this.slf4jLogger.warn(PatchLogger.getMessage(record), record.getThrown());
            }
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            if (this.slf4jLogger.isInfoEnabled()) {
                this.slf4jLogger.info(PatchLogger.getMessage(record), record.getThrown());
            }
        } else if (level.intValue() >= Level.FINE.intValue()) {
            if (this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.debug(PatchLogger.getMessage(record), record.getThrown());
            }
        } else if (this.slf4jLogger.isTraceEnabled()) {
            this.slf4jLogger.trace(PatchLogger.getMessage(record), record.getThrown());
        }
    }

    public void log(Level level, String msg) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            this.slf4jLogger.error(msg);
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            this.slf4jLogger.warn(msg);
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            this.slf4jLogger.info(msg);
        } else if (level.intValue() >= Level.FINE.intValue()) {
            this.slf4jLogger.debug(msg);
        } else {
            this.slf4jLogger.trace(msg);
        }
    }

    public void log(Level level, String msg, Object param1) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.slf4jLogger.isErrorEnabled()) {
                this.slf4jLogger.error(MessageFormat.format(msg, param1));
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.slf4jLogger.isWarnEnabled()) {
                this.slf4jLogger.warn(MessageFormat.format(msg, param1));
            }
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            if (this.slf4jLogger.isInfoEnabled()) {
                this.slf4jLogger.info(MessageFormat.format(msg, param1));
            }
        } else if (level.intValue() >= Level.FINE.intValue()) {
            if (this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.debug(MessageFormat.format(msg, param1));
            }
        } else if (this.slf4jLogger.isTraceEnabled()) {
            this.slf4jLogger.trace(MessageFormat.format(msg, param1));
        }
    }

    public void log(Level level, String msg, Object[] params) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            if (this.slf4jLogger.isErrorEnabled()) {
                this.slf4jLogger.error(MessageFormat.format(msg, params));
            }
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            if (this.slf4jLogger.isWarnEnabled()) {
                this.slf4jLogger.warn(MessageFormat.format(msg, params));
            }
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            if (this.slf4jLogger.isInfoEnabled()) {
                this.slf4jLogger.info(MessageFormat.format(msg, params));
            }
        } else if (level.intValue() >= Level.FINE.intValue()) {
            if (this.slf4jLogger.isDebugEnabled()) {
                this.slf4jLogger.debug(MessageFormat.format(msg, params));
            }
        } else if (this.slf4jLogger.isTraceEnabled()) {
            this.slf4jLogger.trace(MessageFormat.format(msg, params));
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            this.slf4jLogger.error(msg, thrown);
        } else if (level.intValue() >= Level.WARNING.intValue()) {
            this.slf4jLogger.warn(msg, thrown);
        } else if (level.intValue() >= Level.CONFIG.intValue()) {
            this.slf4jLogger.info(msg, thrown);
        } else if (level.intValue() >= Level.FINE.intValue()) {
            this.slf4jLogger.debug(msg, thrown);
        } else {
            this.slf4jLogger.trace(msg, thrown);
        }
    }

    public boolean isLoggable(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return this.slf4jLogger.isErrorEnabled();
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return this.slf4jLogger.isWarnEnabled();
        }
        if (level.intValue() >= Level.CONFIG.intValue()) {
            return this.slf4jLogger.isInfoEnabled();
        }
        if (level.intValue() >= Level.FINE.intValue()) {
            return this.slf4jLogger.isDebugEnabled();
        }
        return this.slf4jLogger.isTraceEnabled();
    }

    public Level getLevel() {
        if (this.slf4jLogger.isErrorEnabled()) {
            return Level.SEVERE;
        }
        if (this.slf4jLogger.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.slf4jLogger.isInfoEnabled()) {
            return Level.CONFIG;
        }
        if (this.slf4jLogger.isDebugEnabled()) {
            return Level.FINE;
        }
        if (this.slf4jLogger.isTraceEnabled()) {
            return Level.FINEST;
        }
        return Level.OFF;
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.log(level, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.log(level, msg);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.log(level, msg, param1);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Object ... params) {
        this.log(level, msg, params);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void logrb(Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.log(level, msg, thrown);
    }

    public void entering(String sourceClass, String sourceMethod) {
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
    }

    public void exiting(String sourceClass, String sourceMethod) {
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return null;
    }

    public PatchLogger getParent() {
        return PatchLogger.getLogger("");
    }

    public void setParent(PatchLogger parent) {
    }

    public void setLevel(Level newLevel) {
    }

    public Handler[] getHandlers() {
        return new Handler[0];
    }

    public static PatchLogger getAnonymousLogger() {
        return PatchLogger.getLogger("");
    }

    public static PatchLogger getAnonymousLogger(String resourceBundleName) {
        return PatchLogger.getLogger("");
    }

    public static final PatchLogger getGlobal() {
        return global;
    }

    private static String getMessage(LogRecord record) {
        String msg = record.getMessage();
        Object[] params = record.getParameters();
        if (params == null) {
            return msg;
        }
        return MessageFormat.format(msg, params);
    }
}

