/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.jaxrs;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JaxrsContextPath {
    private static final ContextKey<String> CONTEXT_KEY = ContextKey.named((String)"opentelemetry-jaxrs-context-path-key");

    private JaxrsContextPath() {
    }

    public static @Nullable Context init(Context context, String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return null;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return context.with(CONTEXT_KEY, (Object)path);
    }

    public static String prepend(Context context, String spanName) {
        String value = (String)context.get(CONTEXT_KEY);
        if (value != null && !value.isEmpty()) {
            return value + spanName;
        }
        return spanName;
    }
}

