/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.State;

public class ExecutorInstrumentationUtils {
    private static final String AGENT_CLASSLOADER_NAME = "io.opentelemetry.javaagent.bootstrap.AgentClassLoader";
    private static final ClassValue<Boolean> INSTRUMENTED_RUNNABLE_CLASS = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> taskClass) {
            ClassLoader taskClassLoader;
            if (taskClass.getName().equals("java.util.concurrent.ForkJoinWorkerThread")) {
                return false;
            }
            if (taskClass.getName().equals("java.util.concurrent.ThreadPoolExecutor$Worker")) {
                return false;
            }
            if (taskClass.getName().equals("org.apache.tomcat.util.net.NioEndpoint$SocketProcessor")) {
                return false;
            }
            if (taskClass.getName().equals("io.reactivex.internal.schedulers.ScheduledRunnable")) {
                return false;
            }
            if (taskClass.getName().equals("org.eclipse.jetty.server.HttpConnection")) {
                return false;
            }
            Class<?> enclosingClass = taskClass.getEnclosingClass();
            if (enclosingClass != null) {
                if (enclosingClass.getName().equals("org.eclipse.jetty.io.nio.SelectChannelEndPoint")) {
                    return false;
                }
                if (enclosingClass.getName().equals("io.netty.util.concurrent.SingleThreadEventExecutor")) {
                    return false;
                }
                if (enclosingClass.getName().equals("okhttp3.internal.concurrent.TaskRunner")) {
                    return false;
                }
                if (enclosingClass.getName().equals("com.squareup.okhttp.ConnectionPool")) {
                    return false;
                }
                if (enclosingClass.getName().equals("org.hornetq.utils.OrderedExecutorFactory$OrderedExecutor")) {
                    return false;
                }
            }
            if ((taskClassLoader = taskClass.getClassLoader()) != null && ExecutorInstrumentationUtils.AGENT_CLASSLOADER_NAME.equals(taskClassLoader.getClass().getName())) {
                return false;
            }
            if (taskClass.getName().startsWith("ratpack.exec.internal.")) {
                return false;
            }
            return true;
        }
    };

    public static boolean shouldAttachStateToTask(Object task) {
        if (task == null) {
            return false;
        }
        if (Context.current() == Context.root()) {
            return false;
        }
        return INSTRUMENTED_RUNNABLE_CLASS.get(task.getClass());
    }

    public static <T> State setupState(ContextStore<T, State> contextStore, T task, Context context) {
        State state = contextStore.putIfAbsent(task, State.FACTORY);
        if (ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            context = ContextPropagationDebug.appendLocations((Context)context, (StackTraceElement[])new Exception().getStackTrace());
        }
        state.setParentContext(context);
        return state;
    }

    public static void cleanUpOnMethodExit(State state, Throwable throwable) {
        if (null != state && null != throwable) {
            state.clearParentContext();
        }
    }
}

