/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.log4j.appender.v2_17;

import io.opentelemetry.instrumentation.api.appender.internal.LogEmitterProvider;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.log4j.appender.v2_17.Log4jHelper;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

class Log4jAppenderInstrumentation
implements TypeInstrumentation {
    Log4jAppenderInstrumentation() {
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"org.apache.logging.log4j.spi.AbstractLogger"));
    }

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.apache.logging.log4j.spi.AbstractLogger"});
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isProtected().or((ElementMatcher)ElementMatchers.isPublic())).and((ElementMatcher)ElementMatchers.named((String)"log")).and((ElementMatcher)ElementMatchers.takesArguments((int)6)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.apache.logging.log4j.Level"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.apache.logging.log4j.Marker"))).and((ElementMatcher)ElementMatchers.takesArgument((int)2, String.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)3, StackTraceElement.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)4, (ElementMatcher)ElementMatchers.named((String)"org.apache.logging.log4j.message.Message"))).and((ElementMatcher)ElementMatchers.takesArgument((int)5, Throwable.class)), Log4jAppenderInstrumentation.class.getName() + "$LogAdvice");
    }

    public static class LogAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.This Logger logger, @Advice.Argument(value=0) Level level, @Advice.Argument(value=4) Message message, @Advice.Argument(value=5) Throwable t, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth = CallDepth.forClass(LogEmitterProvider.class);
            if (callDepth.getAndIncrement() == 0) {
                Log4jHelper.capture(logger, level, message, t);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth.decrementAndGet();
        }
    }
}

