/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.executors;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.internal.ContextPropagationDebug;
import java.util.concurrent.Callable;

public final class ContextPropagatingCallable<T>
implements Callable<T> {
    private final Callable<T> delegate;
    private final Context context;

    public static <T> boolean shouldDecorateCallable(Callable<T> task) {
        return task.getClass().getName().contains("/") && !(task instanceof ContextPropagatingCallable);
    }

    public static <T> Callable<T> propagateContext(Callable<T> task, Context context) {
        return new ContextPropagatingCallable<T>(task, context);
    }

    private ContextPropagatingCallable(Callable<T> delegate, Context context) {
        this.delegate = delegate;
        this.context = ContextPropagationDebug.addDebugInfo((Context)context, delegate);
    }

    @Override
    public T call() throws Exception {
        try (Scope ignored = this.context.makeCurrent();){
            T t = this.delegate.call();
            return t;
        }
    }
}

