/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.javaclassloader;

import io.opentelemetry.javaagent.instrumentation.api.CallDepthThreadLocalMap;
import io.opentelemetry.javaagent.tooling.Constants;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.NameMatchers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ClassLoaderInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return NameMatchers.namedNoneOf((String[])new String[]{"java.lang.ClassLoader", "com.ibm.oti.vm.BootstrapClassLoader", "io.opentelemetry.javaagent.instrumentation.api.AgentClassLoader"}).and((ElementMatcher)AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"java.lang.ClassLoader")));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"loadClass")).and((ElementMatcher)ElementMatchers.takesArguments((int)1).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"java.lang.String"))).or((ElementMatcher)ElementMatchers.takesArguments((int)2).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"java.lang.String"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"boolean"))))).and((ElementMatcher)ElementMatchers.isPublic().or((ElementMatcher)ElementMatchers.isProtected())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())), ClassLoaderInstrumentation.class.getName() + "$LoadClassAdvice");
    }

    public static class LoadClassAdvice {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static Class<?> onEnter(@Advice.Argument(value=0) String name) {
            int callDepth = CallDepthThreadLocalMap.incrementCallDepth(ClassLoader.class);
            if (callDepth > 0) {
                return null;
            }
            try {
                for (String prefix : Holder.bootstrapPackagesPrefixes) {
                    if (!name.startsWith(prefix)) continue;
                    try {
                        Class<?> clazz = Class.forName(name, false, null);
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return null;
                        }
                    }
                }
            }
            finally {
                CallDepthThreadLocalMap.reset(ClassLoader.class);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onExit(@Advice.Return(readOnly=false) Class<?> result, @Advice.Enter Class<?> resultFromBootstrapLoader) {
            if (resultFromBootstrapLoader != null) {
                result = resultFromBootstrapLoader;
            }
        }
    }

    public static class Holder {
        public static final List<String> bootstrapPackagesPrefixes = Holder.findBootstrapPackagePrefixes();

        private static List<String> findBootstrapPackagePrefixes() {
            try {
                Class<?> holderClass = Class.forName("io.opentelemetry.javaagent.instrumentation.api.internal.BootstrapPackagePrefixesHolder", true, null);
                MethodHandle methodHandle = MethodHandles.publicLookup().findStatic(holderClass, "getBoostrapPackagePrefixes", MethodType.methodType(List.class));
                return methodHandle.invokeExact();
            }
            catch (Throwable e) {
                return Arrays.asList(Constants.BOOTSTRAP_PACKAGE_PREFIXES);
            }
        }
    }
}

