/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdacore.v1_0.internal;

import java.time.Duration;

public final class WrapperConfiguration {
    public static final String OTEL_LAMBDA_FLUSH_TIMEOUT_ENV_KEY = "OTEL_INSTRUMENTATION_AWS_LAMBDA_FLUSH_TIMEOUT";
    public static final Duration OTEL_LAMBDA_FLUSH_TIMEOUT_DEFAULT = Duration.ofSeconds(10L);

    private WrapperConfiguration() {
    }

    public static Duration flushTimeout() {
        String lambdaFlushTimeout = System.getenv(OTEL_LAMBDA_FLUSH_TIMEOUT_ENV_KEY);
        if (lambdaFlushTimeout != null && !lambdaFlushTimeout.isEmpty()) {
            try {
                return Duration.ofMillis(Long.parseLong(lambdaFlushTimeout));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return OTEL_LAMBDA_FLUSH_TIMEOUT_DEFAULT;
    }
}

