/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdacore.v1_0.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class HeadersFactory {
    private static final Logger logger = Logger.getLogger(HeadersFactory.class.getName());
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map<String, String> ofStream(InputStream inputStream) {
        try (JsonParser parser = JSON_FACTORY.createParser(inputStream);){
            block15: {
                parser.nextToken();
                if (!parser.isExpectedStartObjectToken()) {
                    logger.fine("Not a JSON object");
                    Map<String, String> map = Collections.emptyMap();
                    return map;
                }
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    parser.nextToken();
                    if (!parser.getCurrentName().equals("headers")) {
                        parser.skipChildren();
                        continue;
                    }
                    break block15;
                }
                return Collections.emptyMap();
            }
            if (!parser.isExpectedStartObjectToken()) {
                logger.fine("Invalid JSON for HTTP headers");
                Map<String, String> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String value = parser.nextTextValue();
                if (value == null) continue;
                headers.put(parser.getCurrentName(), value);
            }
            HashMap<String, String> hashMap = headers;
            return hashMap;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Could not get headers from request", e);
        }
        return Collections.emptyMap();
    }

    private HeadersFactory() {
    }
}

