/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdacore.v1_0.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.AwsLambdaRequest;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;

public final class AwsLambdaFunctionAttributesExtractor
implements AttributesExtractor<AwsLambdaRequest, Object> {
    @Nullable
    private static final MethodHandle GET_FUNCTION_ARN;
    private volatile String accountId;

    public void onStart(AttributesBuilder attributes, Context parentContext, AwsLambdaRequest request) {
        com.amazonaws.services.lambda.runtime.Context awsContext = request.getAwsContext();
        attributes.put(SemanticAttributes.FAAS_EXECUTION, (Object)awsContext.getAwsRequestId());
        String arn = AwsLambdaFunctionAttributesExtractor.getFunctionArn(awsContext);
        if (arn != null) {
            attributes.put(ResourceAttributes.FAAS_ID, (Object)arn);
            attributes.put(ResourceAttributes.CLOUD_ACCOUNT_ID, (Object)this.getAccountId(arn));
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, AwsLambdaRequest request, @Nullable Object response, @Nullable Throwable error) {
    }

    @Nullable
    private static String getFunctionArn(com.amazonaws.services.lambda.runtime.Context awsContext) {
        if (GET_FUNCTION_ARN == null) {
            return null;
        }
        try {
            return GET_FUNCTION_ARN.invoke(awsContext);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccountId(String arn) {
        if (this.accountId == null) {
            AwsLambdaFunctionAttributesExtractor awsLambdaFunctionAttributesExtractor = this;
            synchronized (awsLambdaFunctionAttributesExtractor) {
                String[] arnParts;
                if (this.accountId == null && (arnParts = arn.split(":")).length >= 5) {
                    this.accountId = arnParts[4];
                }
            }
        }
        return this.accountId;
    }

    static {
        MethodHandle getFunctionArn;
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            getFunctionArn = lookup.findVirtual(com.amazonaws.services.lambda.runtime.Context.class, "getInvokedFunctionArn", MethodType.methodType(String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            getFunctionArn = null;
        }
        GET_FUNCTION_ARN = getFunctionArn;
    }
}

