/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdacore.v1_0;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.TracingRequestStreamHandler;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.WrappedLambda;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.WrapperConfiguration;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TracingRequestStreamWrapper
extends TracingRequestStreamHandler {
    private final WrappedLambda wrappedLambda;

    public TracingRequestStreamWrapper() {
        this(AutoConfiguredOpenTelemetrySdk.initialize().getOpenTelemetrySdk(), WrappedLambda.fromConfiguration());
    }

    TracingRequestStreamWrapper(OpenTelemetrySdk openTelemetrySdk, WrappedLambda wrappedLambda) {
        super(openTelemetrySdk, WrapperConfiguration.flushTimeout());
        this.wrappedLambda = wrappedLambda;
    }

    @Override
    protected void doHandleRequest(InputStream inputStream, OutputStream output, Context context) throws IOException {
        if (!(this.wrappedLambda.getTargetObject() instanceof RequestStreamHandler)) {
            throw new IllegalStateException(this.wrappedLambda.getTargetClass().getName() + " is not an instance of RequestStreamHandler");
        }
        ((RequestStreamHandler)this.wrappedLambda.getTargetObject()).handleRequest(inputStream, output, context);
    }
}

