/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdacore.v1_0;

import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.AwsLambdaRequest;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.LambdaUtils;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.ApiGatewayProxyRequest;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.AwsLambdaFunctionInstrumenter;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.AwsLambdaFunctionInstrumenterFactory;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public abstract class TracingRequestStreamHandler
implements RequestStreamHandler {
    private static final Duration DEFAULT_FLUSH_TIMEOUT = Duration.ofSeconds(1L);
    private final OpenTelemetrySdk openTelemetrySdk;
    private final long flushTimeoutNanos;
    private final AwsLambdaFunctionInstrumenter instrumenter;

    protected TracingRequestStreamHandler(OpenTelemetrySdk openTelemetrySdk) {
        this(openTelemetrySdk, DEFAULT_FLUSH_TIMEOUT);
    }

    protected TracingRequestStreamHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout) {
        this(openTelemetrySdk, flushTimeout, AwsLambdaFunctionInstrumenterFactory.createInstrumenter((OpenTelemetry)openTelemetrySdk));
    }

    protected TracingRequestStreamHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout, AwsLambdaFunctionInstrumenter instrumenter) {
        this.openTelemetrySdk = openTelemetrySdk;
        this.flushTimeoutNanos = flushTimeout.toNanos();
        this.instrumenter = instrumenter;
    }

    public void handleRequest(InputStream input, OutputStream output, com.amazonaws.services.lambda.runtime.Context context) throws IOException {
        ApiGatewayProxyRequest proxyRequest = ApiGatewayProxyRequest.forStream(input);
        AwsLambdaRequest request = AwsLambdaRequest.create(context, proxyRequest, proxyRequest.getHeaders());
        Context parentContext = this.instrumenter.extract(request);
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            this.doHandleRequest(proxyRequest.freshStream(), output, context);
            return;
        }
        Context otelContext = this.instrumenter.start(parentContext, request);
        try (Scope ignored = otelContext.makeCurrent();){
            this.doHandleRequest(proxyRequest.freshStream(), new OutputStreamWrapper(output, otelContext, request, this.openTelemetrySdk), context);
        }
        catch (Throwable t) {
            this.instrumenter.end(otelContext, request, null, t);
            LambdaUtils.forceFlush(this.openTelemetrySdk, this.flushTimeoutNanos, TimeUnit.NANOSECONDS);
            throw t;
        }
    }

    protected abstract void doHandleRequest(InputStream var1, OutputStream var2, com.amazonaws.services.lambda.runtime.Context var3) throws IOException;

    private class OutputStreamWrapper
    extends OutputStream {
        private final OutputStream delegate;
        private final Context otelContext;
        private final AwsLambdaRequest request;
        private final OpenTelemetrySdk openTelemetrySdk;

        private OutputStreamWrapper(OutputStream delegate, Context otelContext, AwsLambdaRequest request, OpenTelemetrySdk openTelemetrySdk) {
            this.delegate = delegate;
            this.otelContext = otelContext;
            this.request = request;
            this.openTelemetrySdk = openTelemetrySdk;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            TracingRequestStreamHandler.this.instrumenter.end(this.otelContext, this.request, null, null);
            LambdaUtils.forceFlush(this.openTelemetrySdk, TracingRequestStreamHandler.this.flushTimeoutNanos, TimeUnit.NANOSECONDS);
        }
    }
}

