/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambdacore.v1_0;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.AwsLambdaRequest;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.LambdaUtils;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.AwsLambdaFunctionInstrumenter;
import io.opentelemetry.instrumentation.awslambdacore.v1_0.internal.AwsLambdaFunctionInstrumenterFactory;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class TracingRequestHandler<I, O>
implements RequestHandler<I, O> {
    protected static final Duration DEFAULT_FLUSH_TIMEOUT = Duration.ofSeconds(1L);
    private final AwsLambdaFunctionInstrumenter instrumenter;
    private final OpenTelemetrySdk openTelemetrySdk;
    private final long flushTimeoutNanos;

    protected TracingRequestHandler(OpenTelemetrySdk openTelemetrySdk) {
        this(openTelemetrySdk, DEFAULT_FLUSH_TIMEOUT);
    }

    protected TracingRequestHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout) {
        this(openTelemetrySdk, flushTimeout, AwsLambdaFunctionInstrumenterFactory.createInstrumenter((OpenTelemetry)openTelemetrySdk));
    }

    protected TracingRequestHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout, AwsLambdaFunctionInstrumenter instrumenter) {
        this.openTelemetrySdk = openTelemetrySdk;
        this.flushTimeoutNanos = flushTimeout.toNanos();
        this.instrumenter = instrumenter;
    }

    public final O handleRequest(I input, com.amazonaws.services.lambda.runtime.Context context) {
        AwsLambdaRequest request = AwsLambdaRequest.create(context, input, this.extractHttpHeaders(input));
        Context parentContext = this.instrumenter.extract(request);
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return this.doHandleRequest(input, context);
        }
        Context otelContext = this.instrumenter.start(parentContext, request);
        Throwable error = null;
        O output = null;
        try {
            O o;
            block12: {
                Scope ignored = otelContext.makeCurrent();
                try {
                    o = output = (O)this.doHandleRequest(input, context);
                    if (ignored == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        error = t;
                        throw t;
                    }
                }
                ignored.close();
            }
            return o;
        }
        finally {
            this.instrumenter.end(otelContext, request, output, error);
            LambdaUtils.forceFlush(this.openTelemetrySdk, this.flushTimeoutNanos, TimeUnit.NANOSECONDS);
        }
    }

    protected abstract O doHandleRequest(I var1, com.amazonaws.services.lambda.runtime.Context var2);

    protected Map<String, String> extractHttpHeaders(I input) {
        return Collections.emptyMap();
    }
}

