/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0.internal;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.ParentContextExtractor;

class SqsMessageSpanLinksExtractor
implements SpanLinksExtractor<SQSEvent.SQSMessage> {
    private static final String AWS_TRACE_HEADER_SQS_ATTRIBUTE_KEY = "AWSTraceHeader";

    SqsMessageSpanLinksExtractor() {
    }

    public void extract(SpanLinksBuilder spanLinks, Context parentContext, SQSEvent.SQSMessage message) {
        SpanContext parentCtx;
        String parentHeader = (String)message.getAttributes().get(AWS_TRACE_HEADER_SQS_ATTRIBUTE_KEY);
        if (parentHeader != null && (parentCtx = Span.fromContext((Context)ParentContextExtractor.fromXrayHeader(parentHeader)).getSpanContext()).isValid()) {
            spanLinks.addLink(parentCtx);
        }
    }
}

