/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.extension.aws.AwsXrayPropagator;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.AwsLambdaFunctionInstrumenter;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.MapUtils;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

final class ParentContextExtractor {
    private static final String AWS_TRACE_HEADER_ENV_KEY = "_X_AMZN_TRACE_ID";
    static final String AWS_TRACE_HEADER_PROPAGATOR_KEY = "x-amzn-trace-id";

    static Context extract(Map<String, String> headers, AwsLambdaFunctionInstrumenter instrumenter) {
        Context parentContext = null;
        String parentTraceHeader = System.getenv(AWS_TRACE_HEADER_ENV_KEY);
        if (parentTraceHeader != null) {
            parentContext = ParentContextExtractor.fromXrayHeader(parentTraceHeader);
        }
        if (!ParentContextExtractor.isValidAndSampled(parentContext)) {
            parentContext = ParentContextExtractor.fromHttpHeaders(headers, instrumenter);
        }
        return parentContext;
    }

    private static boolean isValidAndSampled(Context context) {
        if (context == null) {
            return false;
        }
        Span parentSpan = Span.fromContext((Context)context);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        return parentSpanContext.isValid() && parentSpanContext.isSampled();
    }

    private static Context fromHttpHeaders(Map<String, String> headers, AwsLambdaFunctionInstrumenter instrumenter) {
        return instrumenter.extract(MapUtils.lowercaseMap(headers), MapGetter.INSTANCE);
    }

    static Context fromXrayHeader(String parentHeader) {
        return AwsXrayPropagator.getInstance().extract(Context.root(), Collections.singletonMap(AWS_TRACE_HEADER_PROPAGATOR_KEY, parentHeader), (TextMapGetter)MapGetter.INSTANCE);
    }

    private ParentContextExtractor() {
    }

    private static enum MapGetter implements TextMapGetter<Map<String, String>>
    {
        INSTANCE;


        public Iterable<String> keys(Map<String, String> map) {
            return map.keySet();
        }

        public String get(Map<String, String> map, String s) {
            return map.get(s.toLowerCase(Locale.ROOT));
        }
    }
}

