/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HeadersFactory {
    private static final Logger logger = LoggerFactory.getLogger(HeadersFactory.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static Map<String, String> ofStream(InputStream inputStream) {
        try (JsonParser jParser = new JsonFactory().createParser(inputStream);){
            String name;
            do {
                if (jParser.nextToken() == null) return null;
            } while (!"headers".equalsIgnoreCase(name = jParser.getCurrentName()));
            jParser.nextToken();
            Map map = (Map)OBJECT_MAPPER.readValue(jParser, Map.class);
            return map;
        }
        catch (Exception e) {
            logger.debug("Could not get headers from request, ", (Throwable)e);
        }
        return null;
    }

    private HeadersFactory() {
    }
}

