/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0.internal;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.SqsEventAttributesExtractor;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.SqsEventSpanLinksExtractor;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.SqsMessageAttributesExtractor;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.SqsMessageSpanLinksExtractor;

public class AwsLambdaSqsInstrumenterFactory {
    public static Instrumenter<SQSEvent, Void> forEvent(OpenTelemetry openTelemetry) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.opentelemetry.aws-lambda-1.0", AwsLambdaSqsInstrumenterFactory::spanName).addAttributesExtractors(new AttributesExtractor[]{new SqsEventAttributesExtractor()}).addSpanLinksExtractor((SpanLinksExtractor)new SqsEventSpanLinksExtractor()).newInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    public static Instrumenter<SQSEvent.SQSMessage, Void> forMessage(OpenTelemetry openTelemetry) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.opentelemetry.aws-lambda-1.0", message -> message.getEventSource() + " process").addAttributesExtractors(new AttributesExtractor[]{new SqsMessageAttributesExtractor()}).addSpanLinksExtractor((SpanLinksExtractor)new SqsMessageSpanLinksExtractor()).newInstrumenter(SpanKindExtractor.alwaysConsumer());
    }

    private static String spanName(SQSEvent event) {
        String source = "multiple_sources";
        if (!event.getRecords().isEmpty()) {
            String messageSource = ((SQSEvent.SQSMessage)event.getRecords().get(0)).getEventSource();
            for (int i = 1; i < event.getRecords().size(); ++i) {
                SQSEvent.SQSMessage message = (SQSEvent.SQSMessage)event.getRecords().get(i);
                if (message.getEventSource().equals(messageSource)) continue;
                messageSource = null;
                break;
            }
            if (messageSource != null) {
                source = messageSource;
            }
        }
        return source + " process";
    }
}

