/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0.internal;

import com.amazonaws.services.lambda.runtime.Context;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.awslambda.v1_0.AwsLambdaRequest;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;

class AwsLambdaFunctionAttributesExtractor
implements AttributesExtractor<AwsLambdaRequest, Object> {
    @Nullable
    private static final MethodHandle GET_FUNCTION_ARN;
    private volatile String accountId;

    AwsLambdaFunctionAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, AwsLambdaRequest request) {
        Context context = request.getAwsContext();
        this.set(attributes, SemanticAttributes.FAAS_EXECUTION, context.getAwsRequestId());
        this.set(attributes, ResourceAttributes.FAAS_ID, AwsLambdaFunctionAttributesExtractor.getFunctionArn(context));
        this.set(attributes, ResourceAttributes.CLOUD_ACCOUNT_ID, this.getAccountId(AwsLambdaFunctionAttributesExtractor.getFunctionArn(context)));
    }

    public void onEnd(AttributesBuilder attributes, AwsLambdaRequest request, @Nullable Object response, @Nullable Throwable error) {
    }

    @Nullable
    private static String getFunctionArn(Context context) {
        if (GET_FUNCTION_ARN == null) {
            return null;
        }
        try {
            return GET_FUNCTION_ARN.invoke(context);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getAccountId(@Nullable String arn) {
        if (arn == null) {
            return null;
        }
        if (this.accountId == null) {
            AwsLambdaFunctionAttributesExtractor awsLambdaFunctionAttributesExtractor = this;
            synchronized (awsLambdaFunctionAttributesExtractor) {
                String[] arnParts;
                if (this.accountId == null && (arnParts = arn.split(":")).length >= 5) {
                    this.accountId = arnParts[4];
                }
            }
        }
        return this.accountId;
    }

    static {
        MethodHandle getFunctionArn;
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            getFunctionArn = lookup.findVirtual(Context.class, "getInvokedFunctionArn", MethodType.methodType(String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            getFunctionArn = null;
        }
        GET_FUNCTION_ARN = getFunctionArn;
    }
}

