/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.HeadersFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;

public abstract class ApiGatewayProxyRequest {
    private static boolean noHttpPropagationNeeded() {
        Collection fields = GlobalOpenTelemetry.getPropagators().getTextMapPropagator().fields();
        return fields.isEmpty() || ApiGatewayProxyRequest.xrayPropagationFieldsOnly(fields);
    }

    private static boolean xrayPropagationFieldsOnly(Collection<String> fields) {
        return fields.size() == 1 && "x-amzn-trace-id".equalsIgnoreCase(fields.iterator().next());
    }

    public static ApiGatewayProxyRequest forStream(InputStream source) throws IOException {
        if (ApiGatewayProxyRequest.noHttpPropagationNeeded()) {
            return new NoopRequest(source);
        }
        if (source.markSupported()) {
            return new MarkableApiGatewayProxyRequest(source);
        }
        return new CopiedApiGatewayProxyRequest(source);
    }

    @Nullable
    public Map<String, String> getHeaders() throws IOException {
        Map<String, String> headers = HeadersFactory.ofStream(this.freshStream());
        return headers == null ? Collections.emptyMap() : headers;
    }

    public abstract InputStream freshStream() throws IOException;

    private static class CopiedApiGatewayProxyRequest
    extends ApiGatewayProxyRequest {
        private final byte[] data;

        private CopiedApiGatewayProxyRequest(InputStream inputStream) throws IOException {
            this.data = IOUtils.toByteArray((InputStream)inputStream);
        }

        @Override
        public InputStream freshStream() {
            return new ByteArrayInputStream(this.data);
        }
    }

    private static class MarkableApiGatewayProxyRequest
    extends ApiGatewayProxyRequest {
        private final InputStream inputStream;

        private MarkableApiGatewayProxyRequest(InputStream inputStream) {
            this.inputStream = inputStream;
            inputStream.mark(Integer.MAX_VALUE);
        }

        @Override
        public InputStream freshStream() throws IOException {
            this.inputStream.reset();
            this.inputStream.mark(Integer.MAX_VALUE);
            return this.inputStream;
        }
    }

    private static class NoopRequest
    extends ApiGatewayProxyRequest {
        private final InputStream stream;

        private NoopRequest(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public InputStream freshStream() {
            return this.stream;
        }

        @Override
        public Map<String, String> getHeaders() {
            return Collections.emptyMap();
        }
    }
}

