/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0.internal;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.awslambda.v1_0.AwsLambdaRequest;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.MapUtils;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;

final class ApiGatewayProxyAttributesExtractor
implements AttributesExtractor<AwsLambdaRequest, Object> {
    public void onStart(AttributesBuilder attributes, AwsLambdaRequest request) {
        if (request.getInput() instanceof APIGatewayProxyRequestEvent) {
            this.set(attributes, SemanticAttributes.FAAS_TRIGGER, "http");
            this.onRequest(attributes, (APIGatewayProxyRequestEvent)request.getInput());
        }
    }

    void onRequest(AttributesBuilder attributes, APIGatewayProxyRequestEvent request) {
        this.set(attributes, SemanticAttributes.HTTP_METHOD, request.getHttpMethod());
        Map<String, String> headers = MapUtils.lowercaseMap(request.getHeaders());
        this.set(attributes, SemanticAttributes.HTTP_USER_AGENT, headers.get("user-agent"));
        this.set(attributes, SemanticAttributes.HTTP_URL, ApiGatewayProxyAttributesExtractor.getHttpUrl(request, headers));
    }

    private static String getHttpUrl(APIGatewayProxyRequestEvent request, Map<String, String> headers) {
        String path;
        String host;
        StringBuilder str = new StringBuilder();
        String scheme = headers.get("x-forwarded-proto");
        if (scheme != null) {
            str.append(scheme).append("://");
        }
        if ((host = headers.get("host")) != null) {
            str.append(host);
        }
        if ((path = request.getPath()) != null) {
            str.append(path);
        }
        try {
            boolean first = true;
            for (Map.Entry<String, String> entry : MapUtils.emptyIfNull(request.getQueryStringParameters()).entrySet()) {
                String key = URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name());
                String value = URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name());
                str.append(first ? (char)'?' : '&').append(key).append('=').append(value);
                first = false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str.length() == 0 ? null : str.toString();
    }

    public void onEnd(AttributesBuilder attributes, AwsLambdaRequest request, @Nullable Object response, @Nullable Throwable error) {
        Integer statusCode;
        if (response instanceof APIGatewayProxyResponseEvent && (statusCode = ((APIGatewayProxyResponseEvent)response).getStatusCode()) != null) {
            attributes.put(SemanticAttributes.HTTP_STATUS_CODE, statusCode.intValue());
        }
    }

    ApiGatewayProxyAttributesExtractor() {
    }
}

