/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0;

import com.amazonaws.services.lambda.runtime.Context;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

class WrappedLambda {
    public static final String OTEL_LAMBDA_HANDLER_ENV_KEY = "OTEL_INSTRUMENTATION_AWS_LAMBDA_HANDLER";
    private final Object targetObject;
    private final Class<?> targetClass;
    private final String targetMethodName;

    static WrappedLambda fromConfiguration() {
        Class<?> targetClass;
        String lambdaHandler = System.getenv(OTEL_LAMBDA_HANDLER_ENV_KEY);
        if (lambdaHandler == null || lambdaHandler.isEmpty()) {
            throw new IllegalStateException("OTEL_INSTRUMENTATION_AWS_LAMBDA_HANDLER was not specified.");
        }
        String[] split = lambdaHandler.split("::");
        if (split.length != 2) {
            throw new IllegalStateException(lambdaHandler + " is not a valid handler name. Expected format: package.ClassName::methodName");
        }
        String handlerClassName = split[0];
        String targetMethodName = split[1];
        try {
            targetClass = Class.forName(handlerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(handlerClassName + " not found in classpath", e);
        }
        return new WrappedLambda(targetClass, targetMethodName);
    }

    WrappedLambda(Class<?> targetClass, String targetMethodName) {
        this.targetClass = targetClass;
        this.targetMethodName = targetMethodName;
        this.targetObject = this.instantiateTargetClass();
    }

    private Object instantiateTargetClass() {
        Object targetObject;
        try {
            Constructor<?> ctor = this.targetClass.getConstructor(new Class[0]);
            targetObject = ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(this.targetClass.getName() + " does not have an appropriate constructor", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(this.targetClass.getName() + " cannot be an abstract class", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(this.targetClass.getName() + "'s constructor is not accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(this.targetClass.getName() + " threw an exception from the constructor", e);
        }
        return targetObject;
    }

    private static boolean isLastParameterContext(Parameter[] parameters) {
        if (parameters.length == 0) {
            return false;
        }
        return parameters[parameters.length - 1].getType().equals(Context.class);
    }

    Method getRequestTargetMethod() {
        List<Method> methods = Arrays.asList(this.targetClass.getMethods());
        Optional<Method> firstOptional = methods.stream().filter(m -> m.getName().equals(this.targetMethodName)).min(WrappedLambda::methodComparator);
        if (!firstOptional.isPresent()) {
            throw new IllegalStateException("Method " + this.targetMethodName + " not found");
        }
        return firstOptional.get();
    }

    private static int methodComparator(Method a, Method b) {
        if (a.getParameterCount() != b.getParameterCount()) {
            return b.getParameterCount() - a.getParameterCount();
        }
        int onlyOneHasCtx = WrappedLambda.onlyOneHasContextAsLastParam(a, b);
        if (onlyOneHasCtx != 0) {
            return onlyOneHasCtx;
        }
        return WrappedLambda.onlyOneIsBridgeMethod(a, b);
    }

    private static int onlyOneIsBridgeMethod(Method first, Method second) {
        boolean firstBridge = first.isBridge();
        boolean secondBridge = second.isBridge();
        if (firstBridge && !secondBridge) {
            return 1;
        }
        if (!firstBridge && secondBridge) {
            return -1;
        }
        return 0;
    }

    private static int onlyOneHasContextAsLastParam(Method first, Method second) {
        boolean firstCtx = WrappedLambda.isLastParameterContext(first.getParameters());
        boolean secondCtx = WrappedLambda.isLastParameterContext(second.getParameters());
        if (firstCtx && !secondCtx) {
            return -1;
        }
        if (!firstCtx && secondCtx) {
            return 1;
        }
        return 0;
    }

    Object getTargetObject() {
        return this.targetObject;
    }

    Class<?> getTargetClass() {
        return this.targetClass;
    }
}

