/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0;

import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awslambda.v1_0.TracingSqsEventHandler;
import io.opentelemetry.instrumentation.awslambda.v1_0.internal.AwsLambdaSqsInstrumenterFactory;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.time.Duration;

public abstract class TracingSqsMessageHandler
extends TracingSqsEventHandler {
    private final Instrumenter<SQSEvent.SQSMessage, Void> messageInstrumenter;

    protected TracingSqsMessageHandler(OpenTelemetrySdk openTelemetrySdk) {
        this(openTelemetrySdk, DEFAULT_FLUSH_TIMEOUT);
    }

    protected TracingSqsMessageHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout) {
        this(openTelemetrySdk, flushTimeout, AwsLambdaSqsInstrumenterFactory.forEvent((OpenTelemetry)openTelemetrySdk));
    }

    protected TracingSqsMessageHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout, Instrumenter<SQSEvent, Void> eventInstrumenter) {
        this(openTelemetrySdk, flushTimeout, eventInstrumenter, AwsLambdaSqsInstrumenterFactory.forMessage((OpenTelemetry)openTelemetrySdk));
    }

    protected TracingSqsMessageHandler(OpenTelemetrySdk openTelemetrySdk, Duration flushTimeout, Instrumenter<SQSEvent, Void> eventInstrumenter, Instrumenter<SQSEvent.SQSMessage, Void> messageInstrumenter) {
        super(openTelemetrySdk, flushTimeout, eventInstrumenter);
        this.messageInstrumenter = messageInstrumenter;
    }

    @Override
    protected final void handleEvent(SQSEvent event, com.amazonaws.services.lambda.runtime.Context context) {
        Context parentContext = Context.current();
        for (SQSEvent.SQSMessage message : event.getRecords()) {
            if (this.messageInstrumenter.shouldStart(parentContext, (Object)message)) {
                Context otelContext = this.messageInstrumenter.start(parentContext, (Object)message);
                Throwable error = null;
                try {
                    Scope ignored = otelContext.makeCurrent();
                    try {
                        this.handleMessage(message, context);
                        continue;
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                        continue;
                    }
                }
                catch (Throwable t) {
                    error = t;
                    throw t;
                }
                finally {
                    this.messageInstrumenter.end(otelContext, (Object)message, null, error);
                    continue;
                }
            }
            this.handleMessage(message, context);
        }
    }

    protected abstract void handleMessage(SQSEvent.SQSMessage var1, com.amazonaws.services.lambda.runtime.Context var2);
}

