/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.opentelemetry.instrumentation.awslambda.v1_0.LambdaParameters;
import io.opentelemetry.instrumentation.awslambda.v1_0.TracingSqsEventHandler;
import io.opentelemetry.instrumentation.awslambda.v1_0.WrappedLambda;
import io.opentelemetry.instrumentation.awslambda.v1_0.WrapperConfiguration;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TracingSqsEventWrapper
extends TracingSqsEventHandler {
    private final WrappedLambda wrappedLambda;
    private final Method targetMethod;

    public TracingSqsEventWrapper() {
        this(AutoConfiguredOpenTelemetrySdk.initialize().getOpenTelemetrySdk(), WrappedLambda.fromConfiguration());
    }

    TracingSqsEventWrapper(OpenTelemetrySdk openTelemetrySdk, WrappedLambda wrappedLambda) {
        super(openTelemetrySdk, WrapperConfiguration.flushTimeout());
        this.wrappedLambda = wrappedLambda;
        this.targetMethod = wrappedLambda.getRequestTargetMethod();
    }

    @Override
    protected void handleEvent(SQSEvent sqsEvent, Context context) {
        Object[] parameters = LambdaParameters.toArray(this.targetMethod, sqsEvent, context, (event, clazz) -> event);
        try {
            this.targetMethod.invoke(this.wrappedLambda.getTargetObject(), parameters);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is inaccessible", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new IllegalStateException(e.getTargetException());
        }
    }
}

