/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.instrumentation.awslambda.v1_0.LambdaParameters;
import io.opentelemetry.instrumentation.awslambda.v1_0.TracingRequestHandler;
import io.opentelemetry.instrumentation.awslambda.v1_0.WrappedLambda;
import io.opentelemetry.instrumentation.awslambda.v1_0.WrapperConfiguration;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;

abstract class TracingRequestWrapperBase<I, O>
extends TracingRequestHandler<I, O> {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final WrappedLambda wrappedLambda;
    private final Method targetMethod;
    private final BiFunction<I, Class, Object> parameterMapper;

    protected TracingRequestWrapperBase(BiFunction<I, Class, Object> parameterMapper) {
        this(AutoConfiguredOpenTelemetrySdk.initialize().getOpenTelemetrySdk(), WrappedLambda.fromConfiguration(), parameterMapper);
    }

    TracingRequestWrapperBase(OpenTelemetrySdk openTelemetrySdk, WrappedLambda wrappedLambda, BiFunction<I, Class, Object> parameterMapper) {
        super(openTelemetrySdk, WrapperConfiguration.flushTimeout());
        this.wrappedLambda = wrappedLambda;
        this.targetMethod = wrappedLambda.getRequestTargetMethod();
        this.parameterMapper = parameterMapper;
    }

    @Override
    protected O doHandleRequest(I input, Context context) {
        Object result;
        Object[] parameters = LambdaParameters.toArray(this.targetMethod, input, context, this.parameterMapper);
        try {
            result = this.targetMethod.invoke(this.wrappedLambda.getTargetObject(), parameters);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is inaccessible", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : new IllegalStateException(e.getTargetException());
        }
        return (O)result;
    }
}

