/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awslambda.v1_0;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.opentelemetry.instrumentation.awslambda.v1_0.TracingRequestWrapperBase;
import io.opentelemetry.instrumentation.awslambda.v1_0.WrappedLambda;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.util.function.BiFunction;

public class TracingRequestApiGatewayWrapper
extends TracingRequestWrapperBase<APIGatewayProxyRequestEvent, Object> {
    public TracingRequestApiGatewayWrapper() {
        super(TracingRequestApiGatewayWrapper::map);
    }

    TracingRequestApiGatewayWrapper(OpenTelemetrySdk openTelemetrySdk, WrappedLambda wrappedLambda, BiFunction<APIGatewayProxyRequestEvent, Class, Object> mapper) {
        super(openTelemetrySdk, wrappedLambda, mapper);
    }

    static Object map(APIGatewayProxyRequestEvent event, Class clazz) {
        try {
            return OBJECT_MAPPER.readValue(event.getBody(), clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Could not map API Gateway event body to requested parameter type: " + clazz, e);
        }
    }

    @Override
    protected APIGatewayProxyResponseEvent doHandleRequest(APIGatewayProxyRequestEvent input, Context context) {
        Object result = super.doHandleRequest(input, context);
        APIGatewayProxyResponseEvent event = null;
        if (result instanceof APIGatewayProxyResponseEvent) {
            event = (APIGatewayProxyResponseEvent)result;
        } else {
            try {
                event = new APIGatewayProxyResponseEvent();
                event.setBody(OBJECT_MAPPER.writeValueAsString(result));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Could not serialize return value.", e);
            }
        }
        return event;
    }
}

