/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.typedspan;

import io.opentelemetry.auto.typedspan.DelegatingSpan;
import io.opentelemetry.auto.typedspan.RpcSemanticConvention;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.Tracer;

public class RpcSpan
extends DelegatingSpan
implements RpcSemanticConvention {
    protected RpcSpan(Span span) {
        super(span);
    }

    public static RpcSpanBuilder createRpcSpan(Tracer tracer, String spanName) {
        return new RpcSpanBuilder(tracer, spanName);
    }

    @Override
    public Span getSpan() {
        return this.delegate;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public RpcSemanticConvention setNetTransport(String netTransport) {
        this.delegate.setAttribute("net.transport", netTransport);
        return this;
    }

    @Override
    public RpcSemanticConvention setNetPeerIp(String netPeerIp) {
        this.delegate.setAttribute("net.peer.ip", netPeerIp);
        return this;
    }

    @Override
    public RpcSemanticConvention setNetPeerPort(long netPeerPort) {
        this.delegate.setAttribute("net.peer.port", netPeerPort);
        return this;
    }

    @Override
    public RpcSemanticConvention setNetPeerName(String netPeerName) {
        this.delegate.setAttribute("net.peer.name", netPeerName);
        return this;
    }

    @Override
    public RpcSemanticConvention setNetHostIp(String netHostIp) {
        this.delegate.setAttribute("net.host.ip", netHostIp);
        return this;
    }

    @Override
    public RpcSemanticConvention setNetHostPort(long netHostPort) {
        this.delegate.setAttribute("net.host.port", netHostPort);
        return this;
    }

    @Override
    public RpcSemanticConvention setNetHostName(String netHostName) {
        this.delegate.setAttribute("net.host.name", netHostName);
        return this;
    }

    @Override
    public RpcSemanticConvention setRpcService(String rpcService) {
        this.delegate.setAttribute("rpc.service", rpcService);
        return this;
    }

    public static class RpcSpanBuilder {
        protected Span.Builder internalBuilder;

        protected RpcSpanBuilder(Tracer tracer, String spanName) {
            this.internalBuilder = tracer.spanBuilder(spanName);
        }

        public RpcSpanBuilder(Span.Builder spanBuilder) {
            this.internalBuilder = spanBuilder;
        }

        public Span.Builder getSpanBuilder() {
            return this.internalBuilder;
        }

        public RpcSpanBuilder setParent(Span parent) {
            this.internalBuilder.setParent(parent);
            return this;
        }

        public RpcSpanBuilder setParent(SpanContext remoteParent) {
            this.internalBuilder.setParent(remoteParent);
            return this;
        }

        public RpcSpanBuilder setKind(Span.Kind kind) {
            this.internalBuilder.setSpanKind(kind);
            return this;
        }

        public RpcSpan start() {
            return new RpcSpan(this.internalBuilder.startSpan());
        }

        public RpcSpanBuilder setNetTransport(String netTransport) {
            this.internalBuilder.setAttribute("net.transport", netTransport);
            return this;
        }

        public RpcSpanBuilder setNetPeerIp(String netPeerIp) {
            this.internalBuilder.setAttribute("net.peer.ip", netPeerIp);
            return this;
        }

        public RpcSpanBuilder setNetPeerPort(long netPeerPort) {
            this.internalBuilder.setAttribute("net.peer.port", netPeerPort);
            return this;
        }

        public RpcSpanBuilder setNetPeerName(String netPeerName) {
            this.internalBuilder.setAttribute("net.peer.name", netPeerName);
            return this;
        }

        public RpcSpanBuilder setNetHostIp(String netHostIp) {
            this.internalBuilder.setAttribute("net.host.ip", netHostIp);
            return this;
        }

        public RpcSpanBuilder setNetHostPort(long netHostPort) {
            this.internalBuilder.setAttribute("net.host.port", netHostPort);
            return this;
        }

        public RpcSpanBuilder setNetHostName(String netHostName) {
            this.internalBuilder.setAttribute("net.host.name", netHostName);
            return this;
        }

        public RpcSpanBuilder setRpcService(String rpcService) {
            this.internalBuilder.setAttribute("rpc.service", rpcService);
            return this;
        }
    }
}

